/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.aggregatemetric.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.aggregatemetric.aggregations.support.AggregateMetricsValuesSource;
import org.elasticsearch.xpack.aggregatemetric.mapper.AggregateMetricDoubleFieldMapper;

class AggregateMetricBackedSumAggregator
extends NumericMetricsAggregator.SingleValue {
    private final AggregateMetricsValuesSource.AggregateMetricDouble valuesSource;
    private final DocValueFormat format;
    private DoubleArray sums;
    private DoubleArray compensations;

    AggregateMetricBackedSumAggregator(String name, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        assert (valuesSourceConfig.hasValues());
        this.valuesSource = (AggregateMetricsValuesSource.AggregateMetricDouble)valuesSourceConfig.getValuesSource();
        this.sums = context.bigArrays().newDoubleArray(1L, true);
        this.compensations = context.bigArrays().newDoubleArray(1L, true);
        this.format = valuesSourceConfig.format();
    }

    public ScoreMode scoreMode() {
        return this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        final BigArrays bigArrays = this.bigArrays();
        final SortedNumericDoubleValues values = this.valuesSource.getAggregateMetricValues(aggCtx.getLeafReaderContext(), AggregateMetricDoubleFieldMapper.Metric.sum);
        final CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long bucket) throws IOException {
                AggregateMetricBackedSumAggregator.this.sums = bigArrays.grow(AggregateMetricBackedSumAggregator.this.sums, bucket + 1L);
                AggregateMetricBackedSumAggregator.this.compensations = bigArrays.grow(AggregateMetricBackedSumAggregator.this.compensations, bucket + 1L);
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    double sum = AggregateMetricBackedSumAggregator.this.sums.get(bucket);
                    double compensation = AggregateMetricBackedSumAggregator.this.compensations.get(bucket);
                    kahanSummation.reset(sum, compensation);
                    for (int i = 0; i < valuesCount; ++i) {
                        double value = values.nextValue();
                        kahanSummation.add(value);
                    }
                    AggregateMetricBackedSumAggregator.this.compensations.set(bucket, kahanSummation.delta());
                    AggregateMetricBackedSumAggregator.this.sums.set(bucket, kahanSummation.value());
                }
            }
        };
    }

    public double metric(long owningBucketOrd) {
        if (owningBucketOrd >= this.sums.size()) {
            return 0.0;
        }
        return this.sums.get(owningBucketOrd);
    }

    public InternalAggregation buildAggregation(long bucket) {
        if (bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new Sum(this.name, this.sums.get(bucket), this.format, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return Sum.empty((String)this.name, (DocValueFormat)this.format, (Map)this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.sums, this.compensations});
    }
}

