/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.shutdown;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.NodesShutdownMetadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.core.Strings;

public final class NodeSeenService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(NodeSeenService.class);
    final ClusterService clusterService;
    private final MasterServiceTaskQueue<SetSeenNodesShutdownTask> setSeenTaskQueue;

    public NodeSeenService(ClusterService clusterService) {
        this.clusterService = clusterService;
        this.setSeenTaskQueue = clusterService.createTaskQueue("shutdown-seen-nodes-updater", Priority.NORMAL, (ClusterStateTaskExecutor)new SetSeenNodesShutdownExecutor());
        clusterService.addListener((ClusterStateListener)this);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (!event.state().nodes().isLocalNodeElectedMaster()) {
            return;
        }
        boolean thisNodeJustBecameMaster = !event.previousState().nodes().isLocalNodeElectedMaster() && event.state().nodes().isLocalNodeElectedMaster();
        if (!(event.nodesAdded() || thisNodeJustBecameMaster)) {
            return;
        }
        NodesShutdownMetadata eventShutdownMetadata = (NodesShutdownMetadata)event.state().metadata().custom("node_shutdown");
        if (eventShutdownMetadata == null) {
            return;
        }
        Set<String> nodesNotPreviouslySeen = eventShutdownMetadata.getAll().values().stream().filter(singleNodeShutdownMetadata -> !singleNodeShutdownMetadata.getNodeSeen()).map(SingleNodeShutdownMetadata::getNodeId).filter(nodeId -> event.state().nodes().nodeExists(nodeId)).collect(Collectors.toUnmodifiableSet());
        if (!nodesNotPreviouslySeen.isEmpty()) {
            this.setSeenTaskQueue.submitTask("saw new nodes", (ClusterStateTaskListener)new SetSeenNodesShutdownTask(nodesNotPreviouslySeen), null);
        }
    }

    private static class SetSeenNodesShutdownExecutor
    implements ClusterStateTaskExecutor<SetSeenNodesShutdownTask> {
        private SetSeenNodesShutdownExecutor() {
        }

        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<SetSeenNodesShutdownTask> batchExecutionContext) throws Exception {
            ClusterState initialState = batchExecutionContext.initialState();
            HashMap<String, SingleNodeShutdownMetadata> shutdownMetadata = new HashMap<String, SingleNodeShutdownMetadata>(initialState.metadata().nodeShutdowns().getAll());
            HashSet<String> nodesNotPreviouslySeen = new HashSet<String>();
            for (ClusterStateTaskExecutor.TaskContext taskContext : batchExecutionContext.taskContexts()) {
                nodesNotPreviouslySeen.addAll(((SetSeenNodesShutdownTask)taskContext.getTask()).nodesNotPreviouslySeen());
                taskContext.success(() -> {});
            }
            DiscoveryNodes nodes = initialState.nodes();
            shutdownMetadata.replaceAll((k, v) -> {
                if (!v.getNodeSeen() && (nodesNotPreviouslySeen.contains(v.getNodeId()) || nodes.nodeExists(v.getNodeId()))) {
                    return SingleNodeShutdownMetadata.builder((SingleNodeShutdownMetadata)v).setNodeSeen(true).build();
                }
                return v;
            });
            if (shutdownMetadata.equals(initialState.metadata().nodeShutdowns().getAll())) {
                return initialState;
            }
            return ClusterState.builder((ClusterState)initialState).metadata(Metadata.builder((Metadata)initialState.metadata()).putCustom("node_shutdown", (Metadata.Custom)new NodesShutdownMetadata(shutdownMetadata)).build()).build();
        }
    }

    record SetSeenNodesShutdownTask(Set<String> nodesNotPreviouslySeen) implements ClusterStateTaskListener
    {
        public void onFailure(Exception e) {
            logger.warn(() -> Strings.format((String)"failed to mark shutting down nodes as seen: %s", (Object[])new Object[]{this.nodesNotPreviouslySeen}), (Throwable)e);
        }
    }
}

