/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.querydsl.container;

import org.elasticsearch.xpack.ql.execution.search.FieldExtraction;
import org.elasticsearch.xpack.ql.execution.search.QlSourceBuilder;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class SearchHitFieldRef
implements FieldExtraction {
    private final String name;
    private final DataType dataType;
    private final String hitName;

    public SearchHitFieldRef(String name, DataType dataType, boolean isAlias) {
        this(name, dataType, isAlias, null);
    }

    public SearchHitFieldRef(String name, DataType dataType, boolean isAlias, String hitName) {
        this.name = name;
        this.dataType = dataType;
        this.hitName = hitName;
    }

    public String hitName() {
        return this.hitName;
    }

    public String name() {
        return this.name;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void collectFields(QlSourceBuilder sourceBuilder) {
        if (this.hitName != null) {
            return;
        }
        sourceBuilder.addFetchField(this.name, SearchHitFieldRef.format(this.dataType));
    }

    public final boolean supportedByAggsOnlyQuery() {
        return false;
    }

    public String toString() {
        return this.name;
    }

    private static String format(DataType dataType) {
        return dataType == DataTypes.DATETIME ? "epoch_millis" : null;
    }
}

