/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rank.linear;

import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.xpack.rank.linear.ScoreNormalizer;

public class L2ScoreNormalizer
extends ScoreNormalizer {
    public static final L2ScoreNormalizer INSTANCE = new L2ScoreNormalizer();
    public static final String NAME = "l2_norm";
    private static final float EPSILON = 1.0E-6f;
    public static final NodeFeature LINEAR_RETRIEVER_L2_NORM = new NodeFeature("linear_retriever.l2_norm");

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ScoreDoc[] normalizeScores(ScoreDoc[] docs) {
        if (docs.length == 0) {
            return docs;
        }
        double sumOfSquares = 0.0;
        boolean atLeastOneValidScore = false;
        for (ScoreDoc doc : docs) {
            if (Float.isNaN(doc.score)) continue;
            atLeastOneValidScore = true;
            sumOfSquares += (double)(doc.score * doc.score);
        }
        if (!atLeastOneValidScore) {
            return docs;
        }
        double norm = Math.sqrt(sumOfSquares);
        if (norm < (double)1.0E-6f) {
            return docs;
        }
        ScoreDoc[] scoreDocs = new ScoreDoc[docs.length];
        for (int i = 0; i < docs.length; ++i) {
            float score = (float)((double)docs[i].score / norm);
            scoreDocs[i] = new ScoreDoc(docs[i].doc, score, docs[i].shardIndex);
        }
        return scoreDocs;
    }
}

