/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.type;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.DateEsField;
import org.elasticsearch.xpack.esql.core.type.InvalidMappedField;
import org.elasticsearch.xpack.esql.core.type.KeywordEsField;
import org.elasticsearch.xpack.esql.core.type.MultiTypeEsField;
import org.elasticsearch.xpack.esql.core.type.TextEsField;
import org.elasticsearch.xpack.esql.core.type.UnsupportedEsField;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;
import org.elasticsearch.xpack.esql.core.util.PlanStreamOutput;

public class EsField
implements Writeable {
    private static Map<String, Writeable.Reader<? extends EsField>> readers = Map.ofEntries(Map.entry("EsField", EsField::new), Map.entry("DateEsField", DateEsField::new), Map.entry("InvalidMappedField", InvalidMappedField::new), Map.entry("KeywordEsField", KeywordEsField::new), Map.entry("MultiTypeEsField", MultiTypeEsField::new), Map.entry("TextEsField", TextEsField::new), Map.entry("UnsupportedEsField", UnsupportedEsField::new));
    private final DataType esDataType;
    private final boolean aggregatable;
    private final Map<String, EsField> properties;
    private final String name;
    private final boolean isAlias;

    public static Writeable.Reader<? extends EsField> getReader(String name) {
        Writeable.Reader<? extends EsField> result = readers.get(name);
        if (result == null) {
            throw new IllegalArgumentException("Invalid EsField type [" + name + "]");
        }
        return result;
    }

    public EsField(String name, DataType esDataType, Map<String, EsField> properties, boolean aggregatable) {
        this(name, esDataType, properties, aggregatable, false);
    }

    public EsField(String name, DataType esDataType, Map<String, EsField> properties, boolean aggregatable, boolean isAlias) {
        this.name = name;
        this.esDataType = esDataType;
        this.aggregatable = aggregatable;
        this.properties = properties;
        this.isAlias = isAlias;
    }

    public EsField(StreamInput in) throws IOException {
        this.name = PlanStreamInput.readCachedStringWithVersionCheck(in);
        this.esDataType = this.readDataType(in);
        this.properties = in.readImmutableMap(EsField::readFrom);
        this.aggregatable = in.readBoolean();
        this.isAlias = in.readBoolean();
    }

    private DataType readDataType(StreamInput in) throws IOException {
        String name = PlanStreamInput.readCachedStringWithVersionCheck(in);
        if (in.getTransportVersion().before((VersionId)TransportVersions.V_8_16_0) && name.equalsIgnoreCase("NESTED")) {
            return DataType.UNSUPPORTED;
        }
        return DataType.readFrom(name);
    }

    public static <A extends EsField> A readFrom(StreamInput in) throws IOException {
        return ((PlanStreamInput)in).readEsFieldWithCache();
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (((PlanStreamOutput)out).writeEsFieldCacheHeader(this)) {
            this.writeContent(out);
        }
    }

    public void writeContent(StreamOutput out) throws IOException {
        PlanStreamOutput.writeCachedStringWithVersionCheck(out, this.name);
        this.esDataType.writeTo(out);
        out.writeMap(this.properties, (o, x) -> x.writeTo(out));
        out.writeBoolean(this.aggregatable);
        out.writeBoolean(this.isAlias);
    }

    public String getWriteableName() {
        return "EsField";
    }

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.esDataType;
    }

    public boolean isAggregatable() {
        return this.aggregatable;
    }

    @Nullable
    public Map<String, EsField> getProperties() {
        return this.properties;
    }

    public boolean isAlias() {
        return this.isAlias;
    }

    public EsField getExactField() {
        return this;
    }

    public Exact getExactInfo() {
        return Exact.EXACT_FIELD;
    }

    public String toString() {
        return this.name + "@" + this.esDataType.typeName() + "=" + String.valueOf(this.properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EsField field = (EsField)o;
        return this.aggregatable == field.aggregatable && this.isAlias == field.isAlias && this.esDataType == field.esDataType && Objects.equals(this.name, field.name) && Objects.equals(this.properties, field.properties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.esDataType, this.aggregatable, this.properties, this.name, this.isAlias});
    }

    public static final class Exact {
        private static Exact EXACT_FIELD = new Exact(true, null);
        private boolean hasExact;
        private String errorMsg;

        public Exact(boolean hasExact, String errorMsg) {
            this.hasExact = hasExact;
            this.errorMsg = errorMsg;
        }

        public boolean hasExact() {
            return this.hasExact;
        }

        public String errorMsg() {
            return this.errorMsg;
        }
    }
}

