/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression.predicate.regex;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.AbstractStringPattern;
import org.elasticsearch.xpack.esql.core.util.StringUtils;

public class WildcardPattern
extends AbstractStringPattern
implements Writeable {
    private final String wildcard;
    private final String regex;

    public WildcardPattern(String pattern) {
        this.wildcard = pattern;
        this.regex = StringUtils.wildcardToJavaPattern(pattern, '\\');
    }

    public WildcardPattern(StreamInput in) throws IOException {
        this(in.readString());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.wildcard);
    }

    @Override
    public String pattern() {
        return this.wildcard;
    }

    @Override
    public Automaton createAutomaton(boolean ignoreCase) {
        return ignoreCase ? Operations.determinize((Automaton)new RegExp(StringUtils.luceneWildcardToRegExp(this.wildcard), 255, 256).toAutomaton(), (int)10000) : MinimizationOperations.minimize((Automaton)WildcardQuery.toAutomaton((Term)new Term(null, this.wildcard)), (int)10000);
    }

    @Override
    public String asJavaRegex() {
        return this.regex;
    }

    public String asLuceneWildcard() {
        return this.wildcard;
    }

    public String asIndexNameWildcard() {
        return this.wildcard;
    }

    public int hashCode() {
        return Objects.hash(this.wildcard);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WildcardPattern other = (WildcardPattern)obj;
        return Objects.equals(this.wildcard, other.wildcard);
    }
}

