/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.StringProcessor;
import org.elasticsearch.xpack.sql.util.Check;

public class InsertFunctionProcessor
implements Processor {
    private final Processor input;
    private final Processor start;
    private final Processor length;
    private final Processor replacement;
    public static final String NAME = "si";

    public InsertFunctionProcessor(Processor input, Processor start, Processor length, Processor replacement) {
        this.input = input;
        this.start = start;
        this.length = length;
        this.replacement = replacement;
    }

    public InsertFunctionProcessor(StreamInput in) throws IOException {
        this.input = (Processor)in.readNamedWriteable(Processor.class);
        this.start = (Processor)in.readNamedWriteable(Processor.class);
        this.length = (Processor)in.readNamedWriteable(Processor.class);
        this.replacement = (Processor)in.readNamedWriteable(Processor.class);
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.input());
        out.writeNamedWriteable((NamedWriteable)this.start());
        out.writeNamedWriteable((NamedWriteable)this.length());
        out.writeNamedWriteable((NamedWriteable)this.replacement());
    }

    public Object process(Object input) {
        return InsertFunctionProcessor.doProcess(this.input().process(input), this.start().process(input), this.length().process(input), this.replacement().process(input));
    }

    public static Object doProcess(Object input, Object start, Object length, Object replacement) {
        int realStart;
        if (input == null || start == null || length == null || replacement == null) {
            return null;
        }
        if (!(input instanceof String || input instanceof Character)) {
            throw new SqlIllegalArgumentException("A string/char is required; received [{}]", input);
        }
        if (!(replacement instanceof String || replacement instanceof Character)) {
            throw new SqlIllegalArgumentException("A string/char is required; received [{}]", replacement);
        }
        Check.isFixedNumberAndInRange(start, "start", -2147483647L, Integer.MAX_VALUE);
        Check.isFixedNumberAndInRange(length, "length", 0L, Integer.MAX_VALUE);
        int startInt = ((Number)start).intValue() - 1;
        int n = realStart = startInt < 0 ? 0 : startInt;
        if (startInt > input.toString().length()) {
            return input;
        }
        StringBuilder sb = new StringBuilder(input.toString());
        String replString = replacement.toString();
        int cutLength = ((Number)length).intValue();
        StringProcessor.checkResultLength(sb.length() - cutLength + replString.length());
        return sb.replace(realStart, realStart + cutLength, replString).toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InsertFunctionProcessor other = (InsertFunctionProcessor)obj;
        return Objects.equals(this.input(), other.input()) && Objects.equals(this.start(), other.start()) && Objects.equals(this.length(), other.length()) && Objects.equals(this.replacement(), other.replacement());
    }

    public int hashCode() {
        return Objects.hash(this.input(), this.start(), this.length(), this.replacement());
    }

    public Processor input() {
        return this.input;
    }

    public Processor start() {
        return this.start;
    }

    public Processor length() {
        return this.length;
    }

    public Processor replacement() {
        return this.replacement;
    }

    public String getWriteableName() {
        return NAME;
    }
}

