/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.InsertFunctionPipe;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.InsertFunctionProcessor;

public class Insert
extends ScalarFunction {
    private final Expression input;
    private final Expression start;
    private final Expression length;
    private final Expression replacement;

    public Insert(Source source, Expression input, Expression start, Expression length, Expression replacement) {
        super(source, Arrays.asList(input, start, length, replacement));
        this.input = input;
        this.start = start;
        this.length = length;
        this.replacement = replacement;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution sourceResolution = TypeResolutions.isStringAndExact((Expression)this.input, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (sourceResolution.unresolved()) {
            return sourceResolution;
        }
        Expression.TypeResolution startResolution = TypeResolutions.isNumeric((Expression)this.start, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
        if (startResolution.unresolved()) {
            return startResolution;
        }
        Expression.TypeResolution lengthResolution = TypeResolutions.isNumeric((Expression)this.length, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD);
        if (lengthResolution.unresolved()) {
            return lengthResolution;
        }
        return TypeResolutions.isStringAndExact((Expression)this.replacement, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FOURTH);
    }

    public boolean foldable() {
        return this.input.foldable() && this.start.foldable() && this.length.foldable() && this.replacement.foldable();
    }

    public Object fold() {
        return InsertFunctionProcessor.doProcess(this.input.fold(), this.start.fold(), this.length.fold(), this.replacement.fold());
    }

    protected Pipe makePipe() {
        return new InsertFunctionPipe(this.source(), (Expression)this, Expressions.pipe((Expression)this.input), Expressions.pipe((Expression)this.start), Expressions.pipe((Expression)this.length), Expressions.pipe((Expression)this.replacement));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Insert::new, (Object)this.input, (Object)this.start, (Object)this.length, (Object)this.replacement);
    }

    public ScriptTemplate asScript() {
        ScriptTemplate inputScript = this.asScript(this.input);
        ScriptTemplate startScript = this.asScript(this.start);
        ScriptTemplate lengthScript = this.asScript(this.length);
        ScriptTemplate replacementScript = this.asScript(this.replacement);
        return this.asScriptFrom(inputScript, startScript, lengthScript, replacementScript);
    }

    private ScriptTemplate asScriptFrom(ScriptTemplate inputScript, ScriptTemplate startScript, ScriptTemplate lengthScript, ScriptTemplate replacementScript) {
        return new ScriptTemplate(String.format(Locale.ROOT, this.formatTemplate("{sql}.%s(%s,%s,%s,%s)"), "insert", inputScript.template(), startScript.template(), lengthScript.template(), replacementScript.template()), ParamsBuilder.paramsBuilder().script(inputScript.params()).script(startScript.params()).script(lengthScript.params()).script(replacementScript.params()).build(), this.dataType());
    }

    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable((Object)field.exactAttribute().name()).build(), this.dataType());
    }

    public DataType dataType() {
        return DataTypes.KEYWORD;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Insert(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2), newChildren.get(3));
    }
}

