/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.datastreams.GetDataStreamSettingsAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.TransportLocalClusterStateAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetDataStreamSettingsAction
extends TransportLocalClusterStateAction<GetDataStreamSettingsAction.Request, GetDataStreamSettingsAction.Response> {
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final SettingsFilter settingsFilter;

    @Inject
    public TransportGetDataStreamSettingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SettingsFilter settingsFilter, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:monitor/data_stream/settings/get", clusterService, transportService, actionFilters, GetDataStreamSettingsAction.Request::localOnly, (Executor)threadPool.executor("management"));
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.settingsFilter = settingsFilter;
    }

    protected ClusterBlockException checkBlock(GetDataStreamSettingsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void localClusterStateOperation(Task task, GetDataStreamSettingsAction.Request request, ClusterState state, ActionListener<GetDataStreamSettingsAction.Response> listener) throws Exception {
        List dataStreamNames = this.indexNameExpressionResolver.dataStreamNames(this.clusterService.state(), IndicesOptions.DEFAULT, request.indices());
        Map dataStreamMap = state.metadata().dataStreams();
        ArrayList<GetDataStreamSettingsAction.DataStreamSettingsResponse> responseList = new ArrayList<GetDataStreamSettingsAction.DataStreamSettingsResponse>(dataStreamNames.size());
        for (String dataStreamName : dataStreamNames) {
            DataStream dataStream = (DataStream)dataStreamMap.get(dataStreamName);
            Settings settings = this.settingsFilter.filter(dataStream.getSettings());
            Settings effectiveSettings = this.settingsFilter.filter(dataStream.getEffectiveSettings(state.metadata()));
            responseList.add(new GetDataStreamSettingsAction.DataStreamSettingsResponse(dataStreamName, settings, effectiveSettings));
        }
        listener.onResponse((Object)new GetDataStreamSettingsAction.Response(responseList));
    }
}

