/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.units;

import com.ibm.icu.impl.number.DecimalQuantity_DualStorageBCD;
import com.ibm.icu.impl.units.ConversionRates;
import com.ibm.icu.impl.units.MeasureUnitImpl;
import com.ibm.icu.impl.units.UnitConverter;
import com.ibm.icu.number.Precision;
import com.ibm.icu.util.Measure;
import com.ibm.icu.util.MeasureUnit;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ComplexUnitsConverter {
    public static final BigDecimal EPSILON = BigDecimal.valueOf(Math.ulp(1.0));
    public static final BigDecimal EPSILON_MULTIPLIER = BigDecimal.valueOf(1L).add(EPSILON);
    private ArrayList<UnitConverter> unitConverters_;
    private ArrayList<MeasureUnitImpl> units_;
    private ArrayList<MeasureUnit> outputUnits_;

    public ComplexUnitsConverter(MeasureUnitImpl inputUnit, MeasureUnitImpl outputUnits, ConversionRates conversionRates) {
        this.units_ = outputUnits.extractIndividualUnits();
        this.outputUnits_ = new ArrayList(this.units_.size());
        for (MeasureUnitImpl itr : this.units_) {
            this.outputUnits_.add(itr.build());
        }
        assert (!this.units_.isEmpty());
        Collections.sort(this.units_, Collections.reverseOrder(new MeasureUnitImpl.MeasureUnitImplComparator(conversionRates)));
        this.unitConverters_ = new ArrayList();
        int n = this.units_.size();
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                this.unitConverters_.add(new UnitConverter(inputUnit, this.units_.get(i), conversionRates));
                continue;
            }
            this.unitConverters_.add(new UnitConverter(this.units_.get(i - 1), this.units_.get(i), conversionRates));
        }
    }

    public boolean greaterThanOrEqual(BigDecimal quantity, BigDecimal limit) {
        assert (!this.units_.isEmpty());
        return this.unitConverters_.get(0).convert(quantity).multiply(EPSILON_MULTIPLIER).compareTo(limit) >= 0;
    }

    public List<Measure> convert(BigDecimal quantity, Precision rounder) {
        int i;
        ArrayList<Measure> result = new ArrayList<Measure>(this.unitConverters_.size());
        BigDecimal sign = BigDecimal.ONE;
        if (quantity.compareTo(BigDecimal.ZERO) < 0) {
            quantity = quantity.abs();
            sign = sign.negate();
        }
        ArrayList<BigDecimal> intValues = new ArrayList<BigDecimal>(this.unitConverters_.size() - 1);
        int n = this.unitConverters_.size();
        for (i = 0; i < n; ++i) {
            BigDecimal carry;
            quantity = this.unitConverters_.get(i).convert(quantity);
            if (i < n - 1) {
                BigDecimal roundedQuantity = quantity.multiply(EPSILON_MULTIPLIER).setScale(0, RoundingMode.FLOOR);
                intValues.add(roundedQuantity);
                quantity = quantity.subtract(roundedQuantity);
                if (quantity.compareTo(BigDecimal.ZERO) != -1) continue;
                quantity = BigDecimal.ZERO;
                continue;
            }
            if (rounder == null) break;
            DecimalQuantity_DualStorageBCD quant = new DecimalQuantity_DualStorageBCD(quantity);
            rounder.apply(quant);
            quantity = quant.toBigDecimal();
            if (i == 0 || (carry = this.unitConverters_.get(i).convertInverse(quantity).multiply(EPSILON_MULTIPLIER).setScale(0, RoundingMode.FLOOR)).compareTo(BigDecimal.ZERO) <= 0) break;
            quantity = quantity.subtract(this.unitConverters_.get(i).convert(carry));
            intValues.set(i - 1, ((BigDecimal)intValues.get(i - 1)).add(carry));
            for (int j = i - 1; j > 0 && (carry = this.unitConverters_.get(j).convertInverse((BigDecimal)intValues.get(j)).multiply(EPSILON_MULTIPLIER).setScale(0, RoundingMode.FLOOR)).compareTo(BigDecimal.ZERO) > 0; --j) {
                intValues.set(j, ((BigDecimal)intValues.get(j)).subtract(this.unitConverters_.get(j).convert(carry)));
                intValues.set(j - 1, ((BigDecimal)intValues.get(j - 1)).add(carry));
            }
        }
        n = this.unitConverters_.size();
        for (i = 0; i < n; ++i) {
            if (i < n - 1) {
                result.add(new Measure(((BigDecimal)intValues.get(i)).multiply(sign), this.units_.get(i).build()));
                continue;
            }
            result.add(new Measure(quantity.multiply(sign), this.units_.get(i).build()));
        }
        for (i = 0; i < result.size(); ++i) {
            for (int j = i; j < result.size(); ++j) {
                if (!((Measure)result.get(j)).getUnit().equals(this.outputUnits_.get(i)) || j == i) continue;
                Measure tmp = (Measure)result.get(j);
                result.set(j, (Measure)result.get(i));
                result.set(i, tmp);
            }
        }
        return result;
    }

    public String toString() {
        return "ComplexUnitsConverter [unitConverters_=" + this.unitConverters_ + ", units_=" + this.units_ + "]";
    }
}

