/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.netty4;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import java.net.InetSocketAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xpack.security.transport.filter.IPFilter;

@ChannelHandler.Sharable
class IpFilterRemoteAddressFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final IPFilter filter;
    private final String profile;
    private final ThreadContext threadContext;

    IpFilterRemoteAddressFilter(IPFilter filter, String profile, ThreadContext threadContext) {
        this.filter = filter;
        this.profile = profile;
        this.threadContext = threadContext;
    }

    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) throws Exception {
        try (ThreadContext.StoredContext ignore = this.threadContext.newStoredContext();){
            boolean bl = this.filter.accept(this.profile, remoteAddress);
            return bl;
        }
    }
}

