/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support.mapper;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xpack.core.security.authc.support.CachingRealm;
import org.elasticsearch.xpack.core.security.authc.support.UserRoleMapper;

public class ExcludingRoleMapper
implements UserRoleMapper {
    private final UserRoleMapper delegate;
    private final Set<String> rolesToExclude;

    public ExcludingRoleMapper(UserRoleMapper delegate, Collection<String> rolesToExclude) {
        this.delegate = Objects.requireNonNull(delegate);
        this.rolesToExclude = Set.copyOf(rolesToExclude);
    }

    public void resolveRoles(UserRoleMapper.UserData user, ActionListener<Set<String>> listener) {
        this.delegate.resolveRoles(user, listener.delegateFailureAndWrap((l, r) -> l.onResponse(this.excludeRoles((Set<String>)r))));
    }

    private Set<String> excludeRoles(Set<String> resolvedRoles) {
        if (this.rolesToExclude.isEmpty()) {
            return resolvedRoles;
        }
        return Sets.difference(resolvedRoles, this.rolesToExclude);
    }

    public void clearRealmCacheOnChange(CachingRealm realm) {
        this.delegate.clearRealmCacheOnChange(realm);
    }
}

