/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.random.RandomNumber;
import org.ojalgo.type.NumberDefinition;

public class Deterministic
extends RandomNumber {
    private final double myValue;

    public Deterministic() {
        this.myValue = PrimitiveMath.ZERO;
    }

    public Deterministic(Comparable<?> aValue) {
        this.myValue = NumberDefinition.doubleValue(aValue);
    }

    public Deterministic(double aValue) {
        this.myValue = aValue;
    }

    @Override
    public int compareTo(Deterministic o) {
        return Double.compare(this.myValue, o.myValue);
    }

    @Override
    public double getExpected() {
        return this.myValue;
    }

    @Override
    public double getStandardDeviation() {
        return PrimitiveMath.ZERO;
    }

    @Override
    public double getVariance() {
        return PrimitiveMath.ZERO;
    }

    @Override
    protected double generate() {
        return this.myValue;
    }
}

