/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.transformation;

import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.matrix.transformation.HouseholderReference;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.structure.ColumnView;
import org.ojalgo.type.NumberDefinition;

final class HouseholderColumn<N extends Comparable<N>>
extends ColumnView<N>
implements HouseholderReference<N> {
    private int myFirst = 0;
    private final MatrixStore<N> myStore;
    private transient Householder<N> myWorker = null;

    public HouseholderColumn(MatrixStore<N> store) {
        super(store);
        this.myStore = store;
    }

    @Override
    public long count() {
        return this.myStore.countRows();
    }

    @Override
    public double doubleValue(long index) {
        if (index > (long)this.myFirst) {
            return this.myStore.doubleValue(index, this.column());
        }
        if (index == (long)this.myFirst) {
            return PrimitiveMath.ONE;
        }
        return PrimitiveMath.ZERO;
    }

    @Override
    public int first() {
        return this.myFirst;
    }

    @Override
    public N get(long index) {
        if (index > (long)this.myFirst) {
            return this.myStore.get(index, this.column());
        }
        if (index == (long)this.myFirst) {
            return (N)((Comparable)this.myStore.physical().scalar().one().get());
        }
        return (N)((Comparable)this.myStore.physical().scalar().zero().get());
    }

    @Override
    public <P extends Householder<N>> P getWorker(PhysicalStore.Factory<N, ?> factory) {
        if (this.myWorker == null) {
            this.myWorker = factory.makeHouseholder((int)this.count());
        }
        return (P)this.myWorker;
    }

    @Override
    public boolean isZero() {
        double largest = NumberDefinition.doubleValue(this.myStore.aggregateColumn((long)this.myFirst + 1L, this.column(), Aggregator.LARGEST));
        return PrimitiveScalar.isSmall(PrimitiveMath.ONE, largest);
    }

    @Override
    public void point(long row, long col) {
        this.setColumn(col);
        this.myFirst = (int)row;
    }
}

