/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.transformation;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;

public interface Householder<N extends Comparable<N>>
extends Access1D<N> {
    public int first();

    default public void transform(PhysicalStore<N> matrix) {
        matrix.transformLeft(this, 0);
    }

    public static final class Primitive64
    implements Householder<Double> {
        public double beta;
        public int first;
        public final double[] vector;

        public Primitive64(Householder<Double> aTransf) {
            this((int)aTransf.count());
            this.copy(aTransf);
        }

        public Primitive64(int aDim) {
            this.vector = new double[aDim];
            this.beta = PrimitiveMath.ZERO;
            this.first = 0;
        }

        public Primitive64 copy(Householder<Double> source) {
            this.first = source.first();
            double[] tmpVector = this.vector;
            double tmpVal2 = PrimitiveMath.ZERO;
            int tmpSize = (int)source.count();
            for (int i = source.first(); i < tmpSize; ++i) {
                double tmpVal = source.doubleValue(i);
                tmpVal2 += tmpVal * tmpVal;
                tmpVector[i] = tmpVal;
            }
            this.beta = PrimitiveMath.TWO / tmpVal2;
            return this;
        }

        public Primitive64 copy(Householder<Double> source, double precalculatedBeta) {
            this.first = source.first();
            double[] tmpVector = this.vector;
            int tmpSize = (int)source.count();
            for (int i = source.first(); i < tmpSize; ++i) {
                tmpVector[i] = source.doubleValue(i);
            }
            this.beta = precalculatedBeta;
            return this;
        }

        @Override
        public long count() {
            return this.vector.length;
        }

        @Override
        public double doubleValue(long anInd) {
            return this.vector[(int)anInd];
        }

        @Override
        public int first() {
            return this.first;
        }

        @Override
        public Double get(long index) {
            return this.vector[(int)index];
        }

        public String toString() {
            StringBuilder retVal = new StringBuilder("{ ");
            int tmpLastIndex = this.vector.length - 1;
            for (int i = 0; i < tmpLastIndex; ++i) {
                retVal.append(this.get(i));
                retVal.append(", ");
            }
            retVal.append(this.get(tmpLastIndex));
            retVal.append(" }");
            return retVal.toString();
        }
    }

    public static final class Primitive32
    implements Householder<Double> {
        public float beta;
        public int first;
        public final float[] vector;

        public Primitive32(Householder<Double> aTransf) {
            this((int)aTransf.count());
            this.copy(aTransf);
        }

        public Primitive32(int aDim) {
            this.vector = new float[aDim];
            this.beta = (float)PrimitiveMath.ZERO;
            this.first = 0;
        }

        public Primitive32 copy(Householder<Double> source) {
            this.first = source.first();
            float[] tmpVector = this.vector;
            float tmpVal2 = (float)PrimitiveMath.ZERO;
            int tmpSize = (int)source.count();
            for (int i = source.first(); i < tmpSize; ++i) {
                float tmpVal = source.floatValue(i);
                tmpVal2 += tmpVal * tmpVal;
                tmpVector[i] = tmpVal;
            }
            this.beta = (float)PrimitiveMath.TWO / tmpVal2;
            return this;
        }

        public Primitive32 copy(Householder<Double> source, float precalculatedBeta) {
            this.first = source.first();
            float[] tmpVector = this.vector;
            int tmpSize = (int)source.count();
            for (int i = source.first(); i < tmpSize; ++i) {
                tmpVector[i] = source.floatValue(i);
            }
            this.beta = precalculatedBeta;
            return this;
        }

        @Override
        public long count() {
            return this.vector.length;
        }

        @Override
        public double doubleValue(long anInd) {
            return this.vector[(int)anInd];
        }

        @Override
        public int first() {
            return this.first;
        }

        @Override
        public Double get(long index) {
            return this.vector[(int)index];
        }

        public String toString() {
            StringBuilder retVal = new StringBuilder("{ ");
            int tmpLastIndex = this.vector.length - 1;
            for (int i = 0; i < tmpLastIndex; ++i) {
                retVal.append(this.get(i));
                retVal.append(", ");
            }
            retVal.append(this.get(tmpLastIndex));
            retVal.append(" }");
            return retVal.toString();
        }
    }

    public static final class Generic<N extends Scalar<N>>
    implements Householder<N> {
        public N beta;
        public int first;
        public final N[] vector;
        private final Scalar.Factory<N> myFactory;

        public Generic(Scalar.Factory<N> factory, Householder<N> aTransf) {
            this(factory, (int)aTransf.count());
            this.copy(aTransf);
        }

        public Generic(Scalar.Factory<N> factory, int dim) {
            this.vector = (Scalar[])factory.newArrayInstance(dim);
            this.beta = (Scalar)factory.zero().get();
            this.first = 0;
            this.myFactory = factory;
        }

        public Generic<N> copy(Householder<N> source) {
            this.first = source.first();
            N[] tmpVector = this.vector;
            double tmpVal2 = PrimitiveMath.ZERO;
            int tmpSize = (int)source.count();
            for (int i = source.first(); i < tmpSize; ++i) {
                Scalar tmpNmbr = (Scalar)source.get(i);
                double tmpVal = tmpNmbr.norm();
                tmpVal2 += tmpVal * tmpVal;
                tmpVector[i] = tmpNmbr;
            }
            this.beta = (Scalar)this.myFactory.cast(PrimitiveMath.TWO / tmpVal2);
            return this;
        }

        public Generic<N> copy(Householder<N> source, N precalculatedBeta) {
            this.first = source.first();
            N[] tmpVector = this.vector;
            int tmpSize = (int)source.count();
            for (int i = source.first(); i < tmpSize; ++i) {
                tmpVector[i] = (Scalar)source.get(i);
            }
            this.beta = precalculatedBeta;
            return this;
        }

        @Override
        public long count() {
            return this.vector.length;
        }

        @Override
        public double doubleValue(long anInd) {
            return this.vector[(int)anInd].doubleValue();
        }

        @Override
        public int first() {
            return this.first;
        }

        @Override
        public N get(long index) {
            return this.vector[(int)index];
        }

        public String toString() {
            int i;
            StringBuilder retVal = new StringBuilder("{");
            int tmpFirst = this.first;
            int tmpLength = this.vector.length;
            for (i = 0; i < tmpFirst; ++i) {
                retVal.append(ComplexNumber.ZERO);
                retVal.append(", ");
            }
            for (i = this.first; i < tmpLength; ++i) {
                retVal.append(this.vector[i]);
                if (i + 1 >= tmpLength) continue;
                retVal.append(", ");
            }
            retVal.append("}");
            return retVal.toString();
        }
    }
}

