/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.FactoryStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;

final class ZeroStore<N extends Comparable<N>>
extends FactoryStore<N> {
    ZeroStore(PhysicalStore.Factory<N, ?> factory, int rowsCount, int columnsCount) {
        super(factory, rowsCount, columnsCount);
    }

    ZeroStore(PhysicalStore.Factory<N, ?> factory, long rowsCount, long columnsCount) {
        super(factory, rowsCount, columnsCount);
    }

    @Override
    public MatrixStore<N> add(MatrixStore<N> addend) {
        return addend;
    }

    @Override
    public MatrixStore<N> conjugate() {
        return new ZeroStore(this.physical(), this.getColDim(), this.getRowDim());
    }

    @Override
    public double doubleValue(long anInd) {
        return PrimitiveMath.ZERO;
    }

    @Override
    public double doubleValue(long aRow, long aCol) {
        return PrimitiveMath.ZERO;
    }

    @Override
    public int firstInColumn(int col) {
        return this.getRowDim();
    }

    @Override
    public int firstInRow(int row) {
        return this.getColDim();
    }

    @Override
    public N get(long aRow, long aCol) {
        return (N)((Comparable)this.zero().get());
    }

    @Override
    public int limitOfColumn(int col) {
        return 0;
    }

    @Override
    public int limitOfRow(int row) {
        return 0;
    }

    @Override
    public void multiply(Access1D<N> right, TransformableRegion<N> target) {
        target.reset();
    }

    @Override
    public ZeroStore<N> multiply(double scalar) {
        return new ZeroStore(this.physical(), this.getRowDim(), this.getColDim());
    }

    @Override
    public ZeroStore<N> multiply(MatrixStore<N> right) {
        return new ZeroStore(this.physical(), this.getRowDim(), (int)(right.count() / (long)this.getColDim()));
    }

    @Override
    public ZeroStore<N> multiply(N scalar) {
        return new ZeroStore(this.physical(), this.getRowDim(), this.getColDim());
    }

    @Override
    public N multiplyBoth(Access1D<N> leftAndRight) {
        return (N)((Comparable)this.zero().get());
    }

    @Override
    public ZeroStore<N> premultiply(Access1D<N> left) {
        return new ZeroStore(this.physical(), (int)(left.count() / (long)this.getRowDim()), this.getColDim());
    }

    @Override
    public void supplyTo(TransformableRegion<N> receiver) {
        receiver.reset();
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        return this.zero();
    }

    @Override
    public MatrixStore<N> transpose() {
        return new ZeroStore(this.physical(), this.getColDim(), this.getRowDim());
    }
}

