/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.matrix.store.ComposingStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.structure.Access1D;

final class RepeatedColumnsStore<N extends Comparable<N>>
extends ComposingStore<N> {
    private final long myBaseColumns;
    private final int myRepetitions;

    RepeatedColumnsStore(MatrixStore<N> base, int repetitions) {
        super(base, base.countRows(), base.countColumns() * (long)repetitions);
        this.myRepetitions = repetitions;
        this.myBaseColumns = base.countColumns();
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.base().doubleValue(row, col % this.myBaseColumns);
    }

    @Override
    public N get(long row, long col) {
        return this.base().get(row, col % this.myBaseColumns);
    }

    @Override
    public void supplyTo(TransformableRegion<N> receiver) {
        for (long bc = 0L; bc < this.myBaseColumns; ++bc) {
            Access1D column = this.base().sliceColumn(bc);
            for (long r = 0L; r < (long)this.myRepetitions; ++r) {
                receiver.fillColumn(bc + this.myBaseColumns * r, column);
            }
        }
    }
}

