/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Transformation2D;

abstract class MatrixPipeline<N extends Comparable<N>>
implements ElementsSupplier<N> {
    private final long myColumnsCount;
    private final ElementsSupplier<N> myContext;
    private final long myRowsCount;

    MatrixPipeline(ElementsSupplier<N> context) {
        this(context, context.countRows(), context.countColumns());
    }

    MatrixPipeline(ElementsSupplier<N> context, long rowsCount, long columnsCount) {
        this.myContext = context;
        this.myRowsCount = rowsCount;
        this.myColumnsCount = columnsCount;
    }

    @Override
    public final long countColumns() {
        return this.myColumnsCount;
    }

    @Override
    public final long countRows() {
        return this.myRowsCount;
    }

    public final String toString() {
        return this.myRowsCount + "x" + this.myColumnsCount + " " + this.getClass();
    }

    final ElementsSupplier<N> getContext() {
        return this.myContext;
    }

    static final class UnaryOperator<N extends Comparable<N>>
    extends MatrixPipeline<N> {
        private final UnaryFunction<N> myOperator;

        UnaryOperator(ElementsSupplier<N> context, UnaryFunction<N> operator) {
            super(context);
            this.myOperator = operator;
        }

        @Override
        public void supplyTo(TransformableRegion<N> receiver) {
            this.getContext().supplyTo(receiver);
            receiver.modifyAll(this.myOperator);
        }
    }

    static final class Transpose<N extends Comparable<N>>
    extends MatrixPipeline<N> {
        Transpose(ElementsSupplier<N> context) {
            super(context, context.countColumns(), context.countRows());
        }

        @Override
        public void supplyTo(TransformableRegion<N> receiver) {
            this.getContext().supplyTo(receiver.regionByTransposing());
        }

        @Override
        public ElementsSupplier<N> transpose() {
            return this.getContext();
        }
    }

    static final class Transformer<N extends Comparable<N>>
    extends MatrixPipeline<N> {
        private final Transformation2D<N> myTransformer;

        Transformer(ElementsSupplier<N> context, Transformation2D<N> operator) {
            super(context);
            this.myTransformer = operator;
        }

        @Override
        public void supplyTo(TransformableRegion<N> receiver) {
            this.getContext().supplyTo(receiver);
            this.myTransformer.transform(receiver);
        }
    }

    static final class RowsReducer<N extends Comparable<N>>
    extends MatrixPipeline<N> {
        private final Aggregator myAggregator;
        private final MatrixStore<N> myBase;

        RowsReducer(MatrixStore<N> base, Aggregator aggregator) {
            super(base, base.countRows(), 1L);
            this.myBase = base;
            this.myAggregator = aggregator;
        }

        @Override
        public void supplyTo(TransformableRegion<N> receiver) {
            this.myBase.reduceRows(this.myAggregator, receiver);
        }
    }

    static final class RowsModifier<N extends Comparable<N>>
    extends MatrixPipeline<N> {
        private final BinaryFunction<N> myFunction;
        private final Access1D<N> myRightArgumnts;

        RowsModifier(ElementsSupplier<N> base, BinaryFunction<N> modifier, Access1D<N> right) {
            super(base);
            this.myFunction = modifier;
            this.myRightArgumnts = right;
        }

        @Override
        public void supplyTo(TransformableRegion<N> receiver) {
            this.getContext().supplyTo(receiver);
            long limit = Math.min(receiver.countRows(), this.myRightArgumnts.count());
            for (long i = 0L; i < limit; ++i) {
                UnaryFunction<N> modifier = this.myFunction.second(this.myRightArgumnts.get(i));
                receiver.modifyRow(i, modifier);
            }
        }
    }

    static final class Multiplication<N extends Comparable<N>>
    extends MatrixPipeline<N> {
        private final Access1D<N> myLeft;
        private final MatrixStore<N> myRight;

        Multiplication(Access1D<N> left, MatrixStore<N> right) {
            super(right, left.count() / right.countRows(), right.countColumns());
            this.myLeft = left;
            this.myRight = right;
        }

        @Override
        public void supplyTo(TransformableRegion<N> receiver) {
            receiver.fillByMultiplying(this.myLeft, this.myRight);
        }
    }

    static final class ColumnsReducer<N extends Comparable<N>>
    extends MatrixPipeline<N> {
        private final Aggregator myAggregator;
        private final MatrixStore<N> myBase;

        ColumnsReducer(MatrixStore<N> base, Aggregator aggregator) {
            super(base, 1L, base.countColumns());
            this.myBase = base;
            this.myAggregator = aggregator;
        }

        @Override
        public void supplyTo(TransformableRegion<N> receiver) {
            this.myBase.reduceColumns(this.myAggregator, receiver);
        }
    }

    static final class ColumnsModifier<N extends Comparable<N>>
    extends MatrixPipeline<N> {
        private final BinaryFunction<N> myFunction;
        private final Access1D<N> myRightArgumnts;

        ColumnsModifier(ElementsSupplier<N> base, BinaryFunction<N> modifier, Access1D<N> right) {
            super(base);
            this.myFunction = modifier;
            this.myRightArgumnts = right;
        }

        @Override
        public void supplyTo(TransformableRegion<N> receiver) {
            this.getContext().supplyTo(receiver);
            long limit = Math.min(receiver.countColumns(), this.myRightArgumnts.count());
            for (long j = 0L; j < limit; ++j) {
                UnaryFunction<N> modifier = this.myFunction.second(this.myRightArgumnts.get(j));
                receiver.modifyColumn(j, modifier);
            }
        }
    }

    static final class BinaryOperatorRight<N extends Comparable<N>>
    extends MatrixPipeline<N> {
        private final BinaryFunction<N> myOperator;
        private final Access2D<N> myRight;

        BinaryOperatorRight(ElementsSupplier<N> left, BinaryFunction<N> operator, Access2D<N> right) {
            super(left);
            this.myRight = right;
            this.myOperator = operator;
        }

        @Override
        public void supplyTo(TransformableRegion<N> receiver) {
            this.getContext().supplyTo(receiver);
            receiver.modifyMatching(this.myOperator, this.myRight);
        }
    }

    static final class BinaryOperatorLeft<N extends Comparable<N>>
    extends MatrixPipeline<N> {
        private final Access2D<N> myLeft;
        private final BinaryFunction<N> myOperator;

        BinaryOperatorLeft(Access2D<N> left, BinaryFunction<N> operator, ElementsSupplier<N> right) {
            super(right);
            this.myLeft = left;
            this.myOperator = operator;
        }

        @Override
        public void supplyTo(TransformableRegion<N> receiver) {
            this.getContext().supplyTo(receiver);
            receiver.modifyMatching(this.myLeft, this.myOperator);
        }
    }
}

