/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.MatrixFactory;
import org.ojalgo.matrix.Mutator2D;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.LDL;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.SparseStore;
import org.ojalgo.matrix.task.DeterminantTask;
import org.ojalgo.matrix.task.InverterTask;
import org.ojalgo.matrix.task.SolverTask;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.structure.Structure2D;

public final class QuaternionMatrix
extends BasicMatrix<Quaternion, QuaternionMatrix> {
    public static final Factory FACTORY = new Factory();

    QuaternionMatrix(ElementsSupplier<Quaternion> supplier) {
        super(FACTORY.getPhysicalFactory(), supplier);
    }

    public DenseReceiver copy() {
        return new DenseReceiver(this.store().copy());
    }

    @Override
    Cholesky<Quaternion> newCholesky(Structure2D typical) {
        return (Cholesky)Cholesky.QUATERNION.make(typical);
    }

    @Override
    DeterminantTask<Quaternion> newDeterminantTask(Structure2D template) {
        return DeterminantTask.QUATERNION.make(template, this.isHermitian(), false);
    }

    @Override
    Eigenvalue<Quaternion> newEigenvalue(Structure2D typical) {
        return Eigenvalue.QUATERNION.make(typical, this.isHermitian());
    }

    @Override
    QuaternionMatrix newInstance(ElementsSupplier<Quaternion> store) {
        return new QuaternionMatrix(store);
    }

    @Override
    InverterTask<Quaternion> newInverterTask(Structure2D template) {
        return InverterTask.QUATERNION.make(template, this.isHermitian(), false);
    }

    @Override
    LDL<Quaternion> newLDL(Structure2D typical) {
        return (LDL)LDL.QUATERNION.make(typical);
    }

    @Override
    LU<Quaternion> newLU(Structure2D typical) {
        return (LU)LU.QUATERNION.make(typical);
    }

    @Override
    QR<Quaternion> newQR(Structure2D typical) {
        return QR.QUATERNION.make(typical);
    }

    @Override
    SingularValue<Quaternion> newSingularValue(Structure2D typical) {
        return SingularValue.QUATERNION.make(typical);
    }

    @Override
    SolverTask<Quaternion> newSolverTask(Structure2D templateBody, Structure2D templateRHS) {
        return SolverTask.QUATERNION.make(templateBody, templateRHS, this.isHermitian(), false);
    }

    public static final class SparseReceiver
    extends Mutator2D<Quaternion, QuaternionMatrix, SparseStore<Quaternion>> {
        SparseReceiver(SparseStore<Quaternion> delegate) {
            super(delegate);
        }

        @Override
        QuaternionMatrix instantiate(MatrixStore<Quaternion> store) {
            return (QuaternionMatrix)FACTORY.instantiate(store);
        }
    }

    public static final class Factory
    extends MatrixFactory<Quaternion, QuaternionMatrix, DenseReceiver, SparseReceiver> {
        Factory() {
            super(QuaternionMatrix.class, GenericStore.QUATERNION);
        }

        @Override
        DenseReceiver dense(PhysicalStore<Quaternion> store) {
            return new DenseReceiver(store);
        }

        @Override
        SparseReceiver sparse(SparseStore<Quaternion> store) {
            return new SparseReceiver(store);
        }
    }

    public static final class DenseReceiver
    extends Mutator2D<Quaternion, QuaternionMatrix, PhysicalStore<Quaternion>> {
        DenseReceiver(PhysicalStore<Quaternion> delegate) {
            super(delegate);
        }

        @Override
        QuaternionMatrix instantiate(MatrixStore<Quaternion> store) {
            return (QuaternionMatrix)FACTORY.instantiate(store);
        }
    }
}

