/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.MatrixFactory;
import org.ojalgo.matrix.Mutator2D;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.LDL;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.store.SparseStore;
import org.ojalgo.matrix.task.DeterminantTask;
import org.ojalgo.matrix.task.InverterTask;
import org.ojalgo.matrix.task.SolverTask;
import org.ojalgo.structure.Structure2D;

public final class Primitive64Matrix
extends BasicMatrix<Double, Primitive64Matrix> {
    public static final Factory FACTORY = new Factory();

    Primitive64Matrix(ElementsSupplier<Double> supplier) {
        super(FACTORY.getPhysicalFactory(), supplier);
    }

    public DenseReceiver copy() {
        return new DenseReceiver(this.store().copy());
    }

    @Override
    Cholesky<Double> newCholesky(Structure2D typical) {
        return (Cholesky)Cholesky.PRIMITIVE.make(typical);
    }

    @Override
    DeterminantTask<Double> newDeterminantTask(Structure2D template) {
        return DeterminantTask.PRIMITIVE.make(template, this.isHermitian(), false);
    }

    @Override
    Eigenvalue<Double> newEigenvalue(Structure2D typical) {
        return Eigenvalue.PRIMITIVE.make(typical, this.isHermitian());
    }

    @Override
    Primitive64Matrix newInstance(ElementsSupplier<Double> store) {
        return new Primitive64Matrix(store);
    }

    @Override
    InverterTask<Double> newInverterTask(Structure2D base) {
        return InverterTask.PRIMITIVE.make(base, this.isHermitian(), false);
    }

    @Override
    LDL<Double> newLDL(Structure2D typical) {
        return (LDL)LDL.PRIMITIVE.make(typical);
    }

    @Override
    LU<Double> newLU(Structure2D typical) {
        return (LU)LU.PRIMITIVE.make(typical);
    }

    @Override
    QR<Double> newQR(Structure2D typical) {
        return QR.PRIMITIVE.make(typical);
    }

    @Override
    SingularValue<Double> newSingularValue(Structure2D typical) {
        return SingularValue.PRIMITIVE.make(typical);
    }

    @Override
    SolverTask<Double> newSolverTask(Structure2D templateBody, Structure2D templateRHS) {
        return SolverTask.PRIMITIVE.make(templateBody, templateRHS, this.isHermitian(), false);
    }

    public static final class SparseReceiver
    extends Mutator2D<Double, Primitive64Matrix, SparseStore<Double>> {
        SparseReceiver(SparseStore<Double> delegate) {
            super(delegate);
        }

        @Override
        Primitive64Matrix instantiate(MatrixStore<Double> store) {
            return (Primitive64Matrix)FACTORY.instantiate(store);
        }
    }

    public static final class Factory
    extends MatrixFactory<Double, Primitive64Matrix, DenseReceiver, SparseReceiver> {
        Factory() {
            super(Primitive64Matrix.class, Primitive64Store.FACTORY);
        }

        @Override
        DenseReceiver dense(PhysicalStore<Double> store) {
            return new DenseReceiver(store);
        }

        @Override
        SparseReceiver sparse(SparseStore<Double> store) {
            return new SparseReceiver(store);
        }
    }

    public static final class DenseReceiver
    extends Mutator2D<Double, Primitive64Matrix, PhysicalStore<Double>> {
        DenseReceiver(PhysicalStore<Double> delegate) {
            super(delegate);
        }

        @Override
        Primitive64Matrix instantiate(MatrixStore<Double> store) {
            return (Primitive64Matrix)FACTORY.instantiate(store);
        }
    }
}

