/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function;

import java.math.BigDecimal;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.PredicateFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.BigAggregator;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.type.context.NumberContext;

public final class BigFunction
extends FunctionSet<BigDecimal> {
    private static final BigFunction SET = new BigFunction();

    public static BigFunction getSet() {
        return SET;
    }

    private BigFunction() {
    }

    @Override
    public UnaryFunction<BigDecimal> abs() {
        return BigMath.ABS;
    }

    @Override
    public UnaryFunction<BigDecimal> acos() {
        return BigMath.ACOS;
    }

    @Override
    public UnaryFunction<BigDecimal> acosh() {
        return BigMath.ACOSH;
    }

    @Override
    public BinaryFunction<BigDecimal> add() {
        return BigMath.ADD;
    }

    @Override
    public AggregatorSet<BigDecimal> aggregator() {
        return BigAggregator.getSet();
    }

    @Override
    public UnaryFunction<BigDecimal> asin() {
        return BigMath.ASIN;
    }

    @Override
    public UnaryFunction<BigDecimal> asinh() {
        return BigMath.ASINH;
    }

    @Override
    public UnaryFunction<BigDecimal> atan() {
        return BigMath.ATAN;
    }

    @Override
    public BinaryFunction<BigDecimal> atan2() {
        return BigMath.ATAN2;
    }

    @Override
    public UnaryFunction<BigDecimal> atanh() {
        return BigMath.ATANH;
    }

    @Override
    public UnaryFunction<BigDecimal> cardinality() {
        return BigMath.CARDINALITY;
    }

    @Override
    public UnaryFunction<BigDecimal> cbrt() {
        return BigMath.CBRT;
    }

    @Override
    public UnaryFunction<BigDecimal> ceil() {
        return BigMath.CEIL;
    }

    @Override
    public UnaryFunction<BigDecimal> conjugate() {
        return BigMath.CONJUGATE;
    }

    @Override
    public UnaryFunction<BigDecimal> cos() {
        return BigMath.COS;
    }

    @Override
    public UnaryFunction<BigDecimal> cosh() {
        return BigMath.COSH;
    }

    @Override
    public BinaryFunction<BigDecimal> divide() {
        return BigMath.DIVIDE;
    }

    public Unary enforce(NumberContext context) {
        return arg -> context.enforce((BigDecimal)arg);
    }

    @Override
    public UnaryFunction<BigDecimal> exp() {
        return BigMath.EXP;
    }

    @Override
    public UnaryFunction<BigDecimal> expm1() {
        return BigMath.EXPM1;
    }

    @Override
    public UnaryFunction<BigDecimal> floor() {
        return BigMath.FLOOR;
    }

    @Override
    public BinaryFunction<BigDecimal> hypot() {
        return BigMath.HYPOT;
    }

    @Override
    public UnaryFunction<BigDecimal> invert() {
        return BigMath.INVERT;
    }

    @Override
    public UnaryFunction<BigDecimal> log() {
        return BigMath.LOG;
    }

    @Override
    public UnaryFunction<BigDecimal> log10() {
        return BigMath.LOG10;
    }

    @Override
    public UnaryFunction<BigDecimal> log1p() {
        return BigMath.LOG1P;
    }

    @Override
    public UnaryFunction<BigDecimal> logistic() {
        return BigMath.LOGISTIC;
    }

    @Override
    public UnaryFunction<BigDecimal> logit() {
        return BigMath.LOGIT;
    }

    @Override
    public BinaryFunction<BigDecimal> max() {
        return BigMath.MAX;
    }

    @Override
    public BinaryFunction<BigDecimal> min() {
        return BigMath.MIN;
    }

    @Override
    public BinaryFunction<BigDecimal> multiply() {
        return BigMath.MULTIPLY;
    }

    @Override
    public UnaryFunction<BigDecimal> negate() {
        return BigMath.NEGATE;
    }

    @Override
    public BinaryFunction<BigDecimal> pow() {
        return BigMath.POW;
    }

    @Override
    public ParameterFunction<BigDecimal> power() {
        return BigMath.POWER;
    }

    @Override
    public UnaryFunction<BigDecimal> rint() {
        return BigMath.RINT;
    }

    @Override
    public ParameterFunction<BigDecimal> root() {
        return BigMath.ROOT;
    }

    @Override
    public ParameterFunction<BigDecimal> scale() {
        return BigMath.SCALE;
    }

    @Override
    public UnaryFunction<BigDecimal> signum() {
        return BigMath.SIGNUM;
    }

    @Override
    public UnaryFunction<BigDecimal> sin() {
        return BigMath.SIN;
    }

    @Override
    public UnaryFunction<BigDecimal> sinh() {
        return BigMath.SINH;
    }

    @Override
    public UnaryFunction<BigDecimal> sqrt() {
        return BigMath.SQRT;
    }

    @Override
    public UnaryFunction<BigDecimal> sqrt1px2() {
        return BigMath.SQRT1PX2;
    }

    @Override
    public BinaryFunction<BigDecimal> subtract() {
        return BigMath.SUBTRACT;
    }

    @Override
    public UnaryFunction<BigDecimal> tan() {
        return BigMath.TAN;
    }

    @Override
    public UnaryFunction<BigDecimal> tanh() {
        return BigMath.TANH;
    }

    @Override
    public UnaryFunction<BigDecimal> value() {
        return BigMath.VALUE;
    }

    @FunctionalInterface
    public static interface Unary
    extends UnaryFunction<BigDecimal> {
        @Override
        default public double invoke(double arg) {
            return this.invoke(BigDecimal.valueOf(arg)).doubleValue();
        }

        @Override
        default public float invoke(float arg) {
            return this.invoke(BigDecimal.valueOf(arg)).floatValue();
        }
    }

    @FunctionalInterface
    public static interface Predicate
    extends PredicateFunction<BigDecimal> {
        @Override
        default public boolean invoke(double arg) {
            return this.invoke(BigDecimal.valueOf(arg));
        }

        @Override
        default public boolean invoke(float arg) {
            return this.invoke(BigDecimal.valueOf(arg));
        }
    }

    @FunctionalInterface
    public static interface Parameter
    extends ParameterFunction<BigDecimal> {
        @Override
        default public double invoke(double arg, int param) {
            return this.invoke(BigDecimal.valueOf(arg), param).doubleValue();
        }

        @Override
        default public float invoke(float arg, int param) {
            return this.invoke(BigDecimal.valueOf(arg), param).floatValue();
        }
    }

    @FunctionalInterface
    public static interface Consumer
    extends VoidFunction<BigDecimal> {
        @Override
        default public void invoke(double arg) {
            this.invoke(BigDecimal.valueOf(arg));
        }

        @Override
        default public void invoke(float arg) {
            this.invoke(BigDecimal.valueOf(arg));
        }
    }

    @FunctionalInterface
    public static interface Binary
    extends BinaryFunction<BigDecimal> {
        @Override
        default public double invoke(double arg1, double arg2) {
            return this.invoke(BigDecimal.valueOf(arg1), BigDecimal.valueOf(arg2)).doubleValue();
        }

        @Override
        default public float invoke(float arg1, float arg2) {
            return this.invoke(BigDecimal.valueOf(arg1), BigDecimal.valueOf(arg2)).floatValue();
        }
    }
}

