/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc.codecs.lucene70;

import org.apache.lucene.backward_codecs.lucene50.Lucene50CompoundFormat;
import org.apache.lucene.backward_codecs.lucene50.Lucene50LiveDocsFormat;
import org.apache.lucene.backward_codecs.lucene50.Lucene50StoredFieldsFormat;
import org.apache.lucene.backward_codecs.lucene60.Lucene60FieldInfosFormat;
import org.apache.lucene.backward_codecs.lucene70.Lucene70DocValuesFormat;
import org.apache.lucene.backward_codecs.lucene70.Lucene70SegmentInfoFormat;
import org.apache.lucene.codecs.CompoundFormat;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.codecs.PointsFormat;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.perfield.PerFieldDocValuesFormat;
import org.elasticsearch.xpack.lucene.bwc.codecs.BWCCodec;
import org.elasticsearch.xpack.lucene.bwc.codecs.lucene60.Lucene60MetadataOnlyPointsFormat;

public class BWCLucene70Codec
extends BWCCodec {
    private final LiveDocsFormat liveDocsFormat = new Lucene50LiveDocsFormat();
    private final CompoundFormat compoundFormat = new Lucene50CompoundFormat();
    private final StoredFieldsFormat storedFieldsFormat;
    private final DocValuesFormat defaultDVFormat = new Lucene70DocValuesFormat();
    private final DocValuesFormat docValuesFormat = new PerFieldDocValuesFormat(){

        public DocValuesFormat getDocValuesFormatForField(String field) {
            return BWCLucene70Codec.this.defaultDVFormat;
        }
    };
    private final PointsFormat pointsFormat = new Lucene60MetadataOnlyPointsFormat();

    public BWCLucene70Codec() {
        this("BWCLucene70Codec");
    }

    protected BWCLucene70Codec(String name) {
        super(name);
        this.storedFieldsFormat = new Lucene50StoredFieldsFormat(Lucene50StoredFieldsFormat.Mode.BEST_SPEED);
    }

    @Override
    protected FieldInfosFormat originalFieldInfosFormat() {
        return new Lucene60FieldInfosFormat();
    }

    @Override
    protected SegmentInfoFormat originalSegmentInfoFormat() {
        return new Lucene70SegmentInfoFormat();
    }

    public StoredFieldsFormat storedFieldsFormat() {
        return this.storedFieldsFormat;
    }

    public LiveDocsFormat liveDocsFormat() {
        return this.liveDocsFormat;
    }

    public CompoundFormat compoundFormat() {
        return this.compoundFormat;
    }

    public final DocValuesFormat docValuesFormat() {
        return this.docValuesFormat;
    }

    public PointsFormat pointsFormat() {
        return this.pointsFormat;
    }
}

