/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.compute.operator.DriverSleeps;
import org.elasticsearch.compute.operator.OperatorStatus;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;

public class DriverProfile
implements Writeable,
ChunkedToXContentObject {
    private static final TransportVersion ESQL_DRIVER_TASK_DESCRIPTION = TransportVersion.fromName((String)"esql_driver_task_description");
    private final String taskDescription;
    private final long startMillis;
    private final long stopMillis;
    private final long tookNanos;
    private final long cpuNanos;
    private final long iterations;
    private final List<OperatorStatus> operators;
    private final DriverSleeps sleeps;

    public DriverProfile(String taskDescription, long startMillis, long stopMillis, long tookNanos, long cpuNanos, long iterations, List<OperatorStatus> operators, DriverSleeps sleeps) {
        this.taskDescription = taskDescription;
        this.startMillis = startMillis;
        this.stopMillis = stopMillis;
        this.tookNanos = tookNanos;
        this.cpuNanos = cpuNanos;
        this.iterations = iterations;
        this.operators = operators;
        this.sleeps = sleeps;
    }

    public DriverProfile(StreamInput in) throws IOException {
        String string = this.taskDescription = in.getTransportVersion().supports(ESQL_DRIVER_TASK_DESCRIPTION) ? in.readString() : "";
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0)) {
            this.startMillis = in.readVLong();
            this.stopMillis = in.readVLong();
        } else {
            this.startMillis = 0L;
            this.stopMillis = 0L;
        }
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_14_0)) {
            this.tookNanos = in.readVLong();
            this.cpuNanos = in.readVLong();
            this.iterations = in.readVLong();
        } else {
            this.tookNanos = 0L;
            this.cpuNanos = 0L;
            this.iterations = 0L;
        }
        this.operators = in.readCollectionAsImmutableList(OperatorStatus::readFrom);
        this.sleeps = DriverSleeps.read(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().supports(ESQL_DRIVER_TASK_DESCRIPTION)) {
            out.writeString(this.taskDescription);
        }
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0)) {
            out.writeVLong(this.startMillis);
            out.writeVLong(this.stopMillis);
        }
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_14_0)) {
            out.writeVLong(this.tookNanos);
            out.writeVLong(this.cpuNanos);
            out.writeVLong(this.iterations);
        }
        out.writeCollection(this.operators);
        this.sleeps.writeTo(out);
    }

    public String taskDescription() {
        return this.taskDescription;
    }

    public long startMillis() {
        return this.startMillis;
    }

    public long stopMillis() {
        return this.stopMillis;
    }

    public long tookNanos() {
        return this.tookNanos;
    }

    public long cpuNanos() {
        return this.cpuNanos;
    }

    public long iterations() {
        return this.iterations;
    }

    public List<OperatorStatus> operators() {
        return this.operators;
    }

    public DriverSleeps sleeps() {
        return this.sleeps;
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return ChunkedToXContent.builder((ToXContent.Params)params).object(ob -> {
            ob.append((b, p) -> {
                b.field("task_description", this.taskDescription);
                b.timestampFieldsFromUnixEpochMillis("start_millis", "start", this.startMillis);
                b.timestampFieldsFromUnixEpochMillis("stop_millis", "stop", this.stopMillis);
                b.field("took_nanos", this.tookNanos);
                if (b.humanReadable()) {
                    b.field("took_time", (Object)TimeValue.timeValueNanos((long)this.tookNanos));
                }
                b.field("cpu_nanos", this.cpuNanos);
                if (b.humanReadable()) {
                    b.field("cpu_time", (Object)TimeValue.timeValueNanos((long)this.cpuNanos));
                }
                b.field("documents_found", this.operators.stream().mapToLong(OperatorStatus::documentsFound).sum());
                b.field("values_loaded", this.operators.stream().mapToLong(OperatorStatus::valuesLoaded).sum());
                b.field("iterations", this.iterations);
                return b;
            });
            ob.array("operators", this.operators.iterator());
            ob.field("sleeps", (ToXContent)this.sleeps);
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DriverProfile that = (DriverProfile)o;
        return this.taskDescription.equals(that.taskDescription) && this.startMillis == that.startMillis && this.stopMillis == that.stopMillis && this.tookNanos == that.tookNanos && this.cpuNanos == that.cpuNanos && this.iterations == that.iterations && Objects.equals(this.operators, that.operators) && this.sleeps.equals(that.sleeps);
    }

    public int hashCode() {
        return Objects.hash(this.taskDescription, this.startMillis, this.stopMillis, this.tookNanos, this.cpuNanos, this.iterations, this.operators, this.sleeps);
    }

    public String toString() {
        return Strings.toString((ChunkedToXContent)this);
    }
}

