/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopLongAggregator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopLongAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("top", ElementType.LONG));
    private final DriverContext driverContext;
    private final TopLongAggregator.SingleState state;
    private final List<Integer> channels;
    private final int limit;
    private final boolean ascending;

    public TopLongAggregatorFunction(DriverContext driverContext, List<Integer> channels, TopLongAggregator.SingleState state, int limit, boolean ascending) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
        this.limit = limit;
        this.ascending = ascending;
    }

    public static TopLongAggregatorFunction create(DriverContext driverContext, List<Integer> channels, int limit, boolean ascending) {
        return new TopLongAggregatorFunction(driverContext, channels, TopLongAggregator.initSingle(driverContext.bigArrays(), limit, ascending), limit, ascending);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (mask.allFalse()) {
            return;
        }
        if (mask.allTrue()) {
            LongBlock block = (LongBlock)page.getBlock(this.channels.get(0));
            LongVector vector = block.asVector();
            if (vector != null) {
                this.addRawVector(vector);
            } else {
                this.addRawBlock(block);
            }
            return;
        }
        LongBlock block = (LongBlock)page.getBlock(this.channels.get(0));
        LongVector vector = block.asVector();
        if (vector != null) {
            this.addRawVector(vector, mask);
        } else {
            this.addRawBlock(block, mask);
        }
    }

    private void addRawVector(LongVector vector) {
        for (int i = 0; i < vector.getPositionCount(); ++i) {
            TopLongAggregator.combine(this.state, vector.getLong(i));
        }
    }

    private void addRawVector(LongVector vector, BooleanVector mask) {
        for (int i = 0; i < vector.getPositionCount(); ++i) {
            if (!mask.getBoolean(i)) continue;
            TopLongAggregator.combine(this.state, vector.getLong(i));
        }
    }

    private void addRawBlock(LongBlock block) {
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (block.isNull(p)) continue;
            int start = block.getFirstValueIndex(p);
            int end = start + block.getValueCount(p);
            for (int i = start; i < end; ++i) {
                TopLongAggregator.combine(this.state, block.getLong(i));
            }
        }
    }

    private void addRawBlock(LongBlock block, BooleanVector mask) {
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (!mask.getBoolean(p) || block.isNull(p)) continue;
            int start = block.getFirstValueIndex(p);
            int end = start + block.getValueCount(p);
            for (int i = start; i < end; ++i) {
                TopLongAggregator.combine(this.state, block.getLong(i));
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + TopLongAggregatorFunction.intermediateStateDesc().size());
        Object topUncast = page.getBlock(this.channels.get(0));
        if (topUncast.areAllValuesNull()) {
            return;
        }
        LongBlock top = (LongBlock)topUncast;
        assert (top.getPositionCount() == 1);
        TopLongAggregator.combineIntermediate(this.state, top);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = TopLongAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

