/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.aggregation.IpArrayState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

class MinIpAggregator {
    private static final BytesRef INIT_VALUE = new BytesRef(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1});

    MinIpAggregator() {
    }

    private static boolean isBetter(BytesRef value, BytesRef otherValue) {
        return value.compareTo(otherValue) < 0;
    }

    public static SingleState initSingle() {
        return new SingleState();
    }

    public static void combine(SingleState state, BytesRef value) {
        state.add(value);
    }

    public static void combineIntermediate(SingleState state, BytesRef value, boolean seen) {
        if (seen) {
            MinIpAggregator.combine(state, value);
        }
    }

    public static Block evaluateFinal(SingleState state, DriverContext driverContext) {
        return state.toBlock(driverContext);
    }

    public static GroupingState initGrouping(BigArrays bigArrays) {
        return new GroupingState(bigArrays);
    }

    public static void combine(GroupingState state, int groupId, BytesRef value) {
        state.add(groupId, value);
    }

    public static void combineIntermediate(GroupingState state, int groupId, BytesRef value, boolean seen) {
        if (seen) {
            state.add(groupId, value);
        }
    }

    public static void combineStates(GroupingState state, int groupId, GroupingState otherState, int otherGroupId) {
        state.combine(groupId, otherState, otherGroupId);
    }

    public static Block evaluateFinal(GroupingState state, IntVector selected, DriverContext driverContext) {
        return state.toBlock(selected, driverContext);
    }

    public static class SingleState
    implements AggregatorState {
        private final BytesRef internalState = BytesRef.deepCopyOf((BytesRef)INIT_VALUE);
        private boolean seen = false;

        private SingleState() {
        }

        public void add(BytesRef value) {
            if (MinIpAggregator.isBetter(value, this.internalState)) {
                this.seen = true;
                System.arraycopy(value.bytes, value.offset, this.internalState.bytes, 0, this.internalState.length);
            }
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            blocks[offset] = driverContext.blockFactory().newConstantBytesRefBlockWith(this.internalState, 1);
            blocks[offset + 1] = driverContext.blockFactory().newConstantBooleanBlockWith(this.seen, 1);
        }

        Block toBlock(DriverContext driverContext) {
            if (!this.seen) {
                return driverContext.blockFactory().newConstantNullBlock(1);
            }
            return driverContext.blockFactory().newConstantBytesRefBlockWith(this.internalState, 1);
        }

        public void close() {
        }
    }

    public static class GroupingState
    implements GroupingAggregatorState {
        private final BytesRef scratch = new BytesRef();
        private final IpArrayState internalState;

        private GroupingState(BigArrays bigArrays) {
            this.internalState = new IpArrayState(bigArrays, INIT_VALUE);
        }

        public void add(int groupId, BytesRef value) {
            if (MinIpAggregator.isBetter(value, this.internalState.getOrDefault(groupId, this.scratch))) {
                this.internalState.set(groupId, value);
            }
        }

        public void combine(int groupId, GroupingState otherState, int otherGroupId) {
            if (otherState.internalState.hasValue(otherGroupId)) {
                this.add(groupId, otherState.internalState.get(otherGroupId, otherState.scratch));
            }
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            this.internalState.toIntermediate(blocks, offset, selected, driverContext);
        }

        Block toBlock(IntVector selected, DriverContext driverContext) {
            return this.internalState.toValuesBlock(selected, driverContext);
        }

        @Override
        public void enableGroupIdTracking(SeenGroupIds seen) {
            this.internalState.enableGroupIdTracking(seen);
        }

        public void close() {
            Releasables.close((Releasable)this.internalState);
        }
    }
}

