/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.BaseRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.EmbeddingsInput;
import org.elasticsearch.xpack.inference.external.http.sender.ExecutableInferenceRequest;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.RateLimitGroupingModel;

public class TruncatingRequestManager
extends BaseRequestManager {
    private static final Logger logger = LogManager.getLogger(TruncatingRequestManager.class);
    private final ResponseHandler responseHandler;
    private final Function<Truncator.TruncationResult, Request> requestCreator;
    private final Integer maxInputTokens;

    public TruncatingRequestManager(ThreadPool threadPool, RateLimitGroupingModel rateLimitGroupingModel, ResponseHandler responseHandler, Function<Truncator.TruncationResult, Request> requestCreator, @Nullable Integer maxInputTokens) {
        super(threadPool, rateLimitGroupingModel);
        this.responseHandler = Objects.requireNonNull(responseHandler);
        this.requestCreator = Objects.requireNonNull(requestCreator);
        this.maxInputTokens = maxInputTokens;
    }

    @Override
    public void execute(InferenceInputs inferenceInputs, RequestSender requestSender, Supplier<Boolean> hasRequestCompletedFunction, ActionListener<InferenceServiceResults> listener) {
        List<String> docsInput = inferenceInputs.castTo(EmbeddingsInput.class).getInputs();
        Truncator.TruncationResult truncatedInput = Truncator.truncate(docsInput, this.maxInputTokens);
        Request request = this.requestCreator.apply(truncatedInput);
        this.execute(new ExecutableInferenceRequest(requestSender, logger, request, this.responseHandler, hasRequestCompletedFunction, listener));
    }
}

