/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.action.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.action.support.MappedActionFilter;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.InferenceFieldMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexingPressure;
import org.elasticsearch.index.mapper.InferenceMetadataFieldsMapper;
import org.elasticsearch.inference.ChunkInferenceInput;
import org.elasticsearch.inference.ChunkedInference;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceRegistry;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.MinimalServiceSettings;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.UnparsedModel;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.ChunkedInferenceError;
import org.elasticsearch.xpack.inference.InferenceException;
import org.elasticsearch.xpack.inference.InferencePlugin;
import org.elasticsearch.xpack.inference.chunking.ChunkingSettingsBuilder;
import org.elasticsearch.xpack.inference.mapper.SemanticTextField;
import org.elasticsearch.xpack.inference.mapper.SemanticTextUtils;
import org.elasticsearch.xpack.inference.registry.ModelRegistry;

public class ShardBulkInferenceActionFilter
implements MappedActionFilter {
    private static final Logger logger = LogManager.getLogger(ShardBulkInferenceActionFilter.class);
    private static final ByteSizeValue DEFAULT_BATCH_SIZE = ByteSizeValue.ofMb((long)1L);
    public static Setting<ByteSizeValue> INDICES_INFERENCE_BATCH_SIZE = Setting.byteSizeSetting((String)"indices.inference.batch_size", (ByteSizeValue)DEFAULT_BATCH_SIZE, (ByteSizeValue)ByteSizeValue.ONE, (ByteSizeValue)ByteSizeValue.ofMb((long)100L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.OperatorDynamic});
    private static final Object EXPLICIT_NULL = new Object();
    private static final ChunkedInference EMPTY_CHUNKED_INFERENCE = new EmptyChunkedInference();
    private final ClusterService clusterService;
    private final InferenceServiceRegistry inferenceServiceRegistry;
    private final ModelRegistry modelRegistry;
    private final XPackLicenseState licenseState;
    private final IndexingPressure indexingPressure;
    private volatile long batchSizeInBytes;

    public ShardBulkInferenceActionFilter(ClusterService clusterService, InferenceServiceRegistry inferenceServiceRegistry, ModelRegistry modelRegistry, XPackLicenseState licenseState, IndexingPressure indexingPressure) {
        this.clusterService = clusterService;
        this.inferenceServiceRegistry = inferenceServiceRegistry;
        this.modelRegistry = modelRegistry;
        this.licenseState = licenseState;
        this.indexingPressure = indexingPressure;
        this.batchSizeInBytes = ((ByteSizeValue)INDICES_INFERENCE_BATCH_SIZE.get(clusterService.getSettings())).getBytes();
        clusterService.getClusterSettings().addSettingsUpdateConsumer(INDICES_INFERENCE_BATCH_SIZE, this::setBatchSize);
    }

    private void setBatchSize(ByteSizeValue newBatchSize) {
        this.batchSizeInBytes = newBatchSize.getBytes();
    }

    public String actionName() {
        return "indices:data/write/bulk[s]";
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        BulkShardRequest bulkShardRequest;
        Map fieldInferenceMetadata;
        if ("indices:data/write/bulk[s]".equals(action) && (fieldInferenceMetadata = (bulkShardRequest = (BulkShardRequest)request).consumeInferenceFieldMap()) != null && !fieldInferenceMetadata.isEmpty()) {
            IndexingPressure.Coordinating coordinatingIndexingPressure = this.indexingPressure.createCoordinatingOperation(false);
            Runnable onInferenceCompletion = () -> chain.proceed(task, action, request, ActionListener.releaseAfter((ActionListener)listener, (Releasable)coordinatingIndexingPressure));
            this.processBulkShardRequest(fieldInferenceMetadata, bulkShardRequest, onInferenceCompletion, coordinatingIndexingPressure);
            return;
        }
        chain.proceed(task, action, request, listener);
    }

    private void processBulkShardRequest(Map<String, InferenceFieldMetadata> fieldInferenceMap, BulkShardRequest bulkShardRequest, Runnable onCompletion, IndexingPressure.Coordinating coordinatingIndexingPressure) {
        IndexMetadata index = this.clusterService.state().getMetadata().index(bulkShardRequest.index());
        boolean useLegacyFormat = !InferenceMetadataFieldsMapper.isEnabled((Settings)index.getSettings());
        new AsyncBulkShardInferenceAction(useLegacyFormat, fieldInferenceMap, bulkShardRequest, onCompletion, coordinatingIndexingPressure).run();
    }

    private static void appendSourceAndInferenceMetadata(XContentBuilder builder, BytesReference source, XContentType xContentType, Map<String, Object> inferenceFieldsMap) throws IOException {
        builder.startObject();
        try (XContentParser parser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);){
            parser.nextToken();
            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                builder.copyCurrentStructure(parser);
            }
        }
        builder.field("_inference_fields");
        parser = XContentHelper.mapToXContentParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, inferenceFieldsMap);
        try {
            builder.copyCurrentStructure(parser);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
        builder.endObject();
    }

    static IndexRequest getIndexRequestOrNull(DocWriteRequest<?> docWriteRequest) {
        if (docWriteRequest instanceof IndexRequest) {
            IndexRequest indexRequest = (IndexRequest)docWriteRequest;
            return indexRequest;
        }
        if (docWriteRequest instanceof UpdateRequest) {
            UpdateRequest updateRequest = (UpdateRequest)docWriteRequest;
            return updateRequest.doc();
        }
        return null;
    }

    private class AsyncBulkShardInferenceAction
    implements Runnable {
        private final boolean useLegacyFormat;
        private final Map<String, InferenceFieldMetadata> fieldInferenceMap;
        private final BulkShardRequest bulkShardRequest;
        private final Runnable onCompletion;
        private final AtomicArray<FieldInferenceResponseAccumulator> inferenceResults;
        private final IndexingPressure.Coordinating coordinatingIndexingPressure;

        private AsyncBulkShardInferenceAction(boolean useLegacyFormat, Map<String, InferenceFieldMetadata> fieldInferenceMap, BulkShardRequest bulkShardRequest, Runnable onCompletion, IndexingPressure.Coordinating coordinatingIndexingPressure) {
            this.useLegacyFormat = useLegacyFormat;
            this.fieldInferenceMap = fieldInferenceMap;
            this.bulkShardRequest = bulkShardRequest;
            this.inferenceResults = new AtomicArray(bulkShardRequest.items().length);
            this.onCompletion = onCompletion;
            this.coordinatingIndexingPressure = coordinatingIndexingPressure;
        }

        @Override
        public void run() {
            this.executeNext(0);
        }

        private void executeNext(int itemOffset) {
            int itemIndex;
            BulkItemRequest item;
            if (itemOffset >= this.bulkShardRequest.items().length) {
                this.onCompletion.run();
                return;
            }
            BulkItemRequest[] items = this.bulkShardRequest.items();
            HashMap<String, List<FieldInferenceRequest>> fieldRequestsMap = new HashMap<String, List<FieldInferenceRequest>>();
            long totalInputLength = 0L;
            for (itemIndex = itemOffset; itemIndex < items.length && totalInputLength < ShardBulkInferenceActionFilter.this.batchSizeInBytes; totalInputLength += this.addFieldInferenceRequests(item, itemIndex, fieldRequestsMap), ++itemIndex) {
                item = items[itemIndex];
            }
            int nextItemOffset = itemIndex;
            Runnable onInferenceCompletion = () -> {
                try {
                    for (int i = itemOffset; i < nextItemOffset; ++i) {
                        FieldInferenceResponseAccumulator result = (FieldInferenceResponseAccumulator)this.inferenceResults.get(i);
                        if (result == null) continue;
                        BulkItemRequest item = items[i];
                        try {
                            this.applyInferenceResponses(item, result);
                        }
                        catch (Exception exc) {
                            item.abort(this.bulkShardRequest.index(), exc);
                        }
                        this.inferenceResults.set(i, null);
                    }
                }
                finally {
                    this.executeNext(nextItemOffset);
                }
            };
            try (RefCountingRunnable releaseOnFinish = new RefCountingRunnable(onInferenceCompletion);){
                for (Map.Entry entry : fieldRequestsMap.entrySet()) {
                    this.executeChunkedInferenceAsync((String)entry.getKey(), null, (List)entry.getValue(), releaseOnFinish.acquire());
                }
            }
        }

        private void executeChunkedInferenceAsync(String inferenceId, @Nullable InferenceProvider inferenceProvider, List<FieldInferenceRequest> requests, Releasable onFinish) {
            if (inferenceProvider == null) {
                ActionListener modelLoadingListener = ActionListener.wrap(unparsedModel -> {
                    Optional service = ShardBulkInferenceActionFilter.this.inferenceServiceRegistry.getService(unparsedModel.service());
                    if (!service.isEmpty()) {
                        InferenceProvider provider = new InferenceProvider((InferenceService)service.get(), ((InferenceService)service.get()).parsePersistedConfigWithSecrets(inferenceId, unparsedModel.taskType(), unparsedModel.settings(), unparsedModel.secrets()));
                        this.executeChunkedInferenceAsync(inferenceId, provider, requests, onFinish);
                    } else {
                        try (Releasable releasable = onFinish;){
                            for (FieldInferenceRequest request : requests) {
                                ((FieldInferenceResponseAccumulator)this.inferenceResults.get((int)request.bulkItemIndex)).failures.add((Exception)new ResourceNotFoundException("Inference service [{}] not found for field [{}]", new Object[]{unparsedModel.service(), request.field}));
                            }
                        }
                    }
                }, exc -> {
                    try (Releasable releasable = onFinish;){
                        for (FieldInferenceRequest request : requests) {
                            Object failure = ExceptionsHelper.unwrap((Throwable)exc, (Class[])new Class[]{ResourceNotFoundException.class}) instanceof ResourceNotFoundException ? new ResourceNotFoundException("Inference id [{}] not found for field [{}]", new Object[]{inferenceId, request.field}) : new InferenceException("Error loading inference for inference id [{}] on field [{}]", (Throwable)exc, inferenceId, request.field);
                            ((FieldInferenceResponseAccumulator)this.inferenceResults.get((int)request.bulkItemIndex)).failures.add((Exception)failure);
                        }
                        if (ExceptionsHelper.status((Throwable)exc).getStatus() >= 500) {
                            List<String> fields = requests.stream().map(FieldInferenceRequest::field).distinct().toList();
                            logger.error("Error loading inference for inference id [" + inferenceId + "] on fields " + String.valueOf(fields), (Throwable)exc);
                        }
                    }
                });
                ShardBulkInferenceActionFilter.this.modelRegistry.getModelWithSecrets(inferenceId, (ActionListener<UnparsedModel>)modelLoadingListener);
                return;
            }
            List inputs = requests.stream().map(r -> new ChunkInferenceInput(r.input, r.chunkingSettings)).collect(Collectors.toList());
            ActionListener completionListener = ActionListener.wrap(results -> {
                try (Releasable releasable = onFinish;){
                    Iterator requestsIterator = requests.iterator();
                    for (ChunkedInference result : results) {
                        FieldInferenceRequest request = (FieldInferenceRequest)requestsIterator.next();
                        FieldInferenceResponseAccumulator acc = (FieldInferenceResponseAccumulator)this.inferenceResults.get(request.bulkItemIndex);
                        if (result instanceof ChunkedInferenceError) {
                            ChunkedInferenceError error = (ChunkedInferenceError)result;
                            acc.addFailure((Exception)((Object)new InferenceException("Exception when running inference id [{}] on field [{}]", error.exception(), inferenceProvider.model.getInferenceEntityId(), request.field)));
                            continue;
                        }
                        acc.addOrUpdateResponse(new FieldInferenceResponse(request.field(), request.sourceField(), this.useLegacyFormat ? request.input() : null, request.inputOrder(), request.offsetAdjustment(), inferenceProvider.model, result));
                    }
                }
            }, exc -> {
                try (Releasable releasable = onFinish;){
                    for (FieldInferenceRequest request : requests) {
                        this.addInferenceResponseFailure(request.bulkItemIndex, (Exception)((Object)new InferenceException("Exception when running inference id [{}] on field [{}]", (Throwable)exc, inferenceProvider.model.getInferenceEntityId(), request.field)));
                    }
                    if (ExceptionsHelper.status((Throwable)exc).getStatus() >= 500) {
                        List<String> fields = requests.stream().map(FieldInferenceRequest::field).distinct().toList();
                        logger.error("Exception when running inference id [" + inferenceProvider.model.getInferenceEntityId() + "] on fields " + String.valueOf(fields), (Throwable)exc);
                    }
                }
            });
            inferenceProvider.service().chunkedInfer(inferenceProvider.model(), null, inputs, Map.of(), InputType.INTERNAL_INGEST, TimeValue.MAX_VALUE, completionListener);
        }

        private long addFieldInferenceRequests(BulkItemRequest item, int itemIndex, Map<String, List<FieldInferenceRequest>> requestsMap) {
            IndexRequestWithIndexingPressure indexRequest;
            boolean isUpdateRequest = false;
            DocWriteRequest docWriteRequest = item.request();
            if (docWriteRequest instanceof IndexRequest) {
                IndexRequest ir = (IndexRequest)docWriteRequest;
                indexRequest = new IndexRequestWithIndexingPressure(ir);
            } else {
                docWriteRequest = item.request();
                if (docWriteRequest instanceof UpdateRequest) {
                    UpdateRequest updateRequest = (UpdateRequest)docWriteRequest;
                    isUpdateRequest = true;
                    if (updateRequest.script() != null) {
                        this.addInferenceResponseFailure(itemIndex, (Exception)new ElasticsearchStatusException("Cannot apply update with a script on indices that contain [{}] field(s)", RestStatus.BAD_REQUEST, new Object[]{"semantic_text"}));
                        return 0L;
                    }
                    indexRequest = new IndexRequestWithIndexingPressure(updateRequest.doc());
                } else {
                    return 0L;
                }
            }
            Map docMap = indexRequest.getIndexRequest().sourceAsMap();
            long inputLength = 0L;
            block2: for (InferenceFieldMetadata entry : this.fieldInferenceMap.values()) {
                Object inferenceMetadataFieldsValue;
                Object originalFieldValue;
                String field = entry.getName();
                String inferenceId = entry.getInferenceId();
                ChunkingSettings chunkingSettings = ChunkingSettingsBuilder.fromMap(entry.getChunkingSettings(), false);
                if (this.useLegacyFormat ? (originalFieldValue = XContentMapValues.extractValue((String)field, (Map)docMap)) instanceof Map || originalFieldValue == null && entry.getSourceFields().length == 1 : (inferenceMetadataFieldsValue = XContentMapValues.extractValue((String)("_inference_fields." + field), (Map)docMap, (Object)EXPLICIT_NULL)) != null) continue;
                int order = 0;
                for (String sourceField : entry.getSourceFields()) {
                    List<String> values;
                    FieldInferenceResponseAccumulator slot;
                    Object valueObj = XContentMapValues.extractValue((String)sourceField, (Map)docMap, (Object)EXPLICIT_NULL);
                    if (!this.useLegacyFormat && isUpdateRequest && valueObj == EXPLICIT_NULL) {
                        if (!this.incrementIndexingPressure(indexRequest, itemIndex)) {
                            return inputLength;
                        }
                        slot = this.ensureResponseAccumulatorSlot(itemIndex);
                        slot.addOrUpdateResponse(new FieldInferenceResponse(field, sourceField, null, order++, 0, null, EMPTY_CHUNKED_INFERENCE));
                        continue;
                    }
                    if (valueObj == null || valueObj == EXPLICIT_NULL) {
                        if (!isUpdateRequest || !this.useLegacyFormat) continue;
                        this.addInferenceResponseFailure(itemIndex, (Exception)new ElasticsearchStatusException("Field [{}] must be specified on an update request to calculate inference for field [{}]", RestStatus.BAD_REQUEST, new Object[]{sourceField, field}));
                        continue block2;
                    }
                    slot = this.ensureResponseAccumulatorSlot(itemIndex);
                    try {
                        values = SemanticTextUtils.nodeStringValues(field, valueObj);
                    }
                    catch (Exception exc) {
                        this.addInferenceResponseFailure(itemIndex, exc);
                        continue block2;
                    }
                    if (!InferencePlugin.INFERENCE_API_FEATURE.check(ShardBulkInferenceActionFilter.this.licenseState)) {
                        this.addInferenceResponseFailure(itemIndex, (Exception)LicenseUtils.newComplianceException((String)"inference"));
                        continue block2;
                    }
                    List requests = requestsMap.computeIfAbsent(inferenceId, k -> new ArrayList());
                    int offsetAdjustment = 0;
                    for (String v : values) {
                        if (!this.incrementIndexingPressure(indexRequest, itemIndex)) {
                            return inputLength;
                        }
                        if (v.isBlank()) {
                            slot.addOrUpdateResponse(new FieldInferenceResponse(field, sourceField, v, order++, 0, null, EMPTY_CHUNKED_INFERENCE));
                        } else {
                            requests.add(new FieldInferenceRequest(itemIndex, field, sourceField, v, order++, offsetAdjustment, chunkingSettings));
                            inputLength += (long)v.length();
                        }
                        offsetAdjustment += v.length() + 1;
                    }
                }
            }
            return inputLength;
        }

        private boolean incrementIndexingPressure(IndexRequestWithIndexingPressure indexRequest, int itemIndex) {
            boolean success = true;
            if (!indexRequest.isIndexingPressureIncremented()) {
                try {
                    this.coordinatingIndexingPressure.increment(1, (long)indexRequest.getIndexRequest().source().length());
                    indexRequest.setIndexingPressureIncremented();
                }
                catch (EsRejectedExecutionException e) {
                    this.addInferenceResponseFailure(itemIndex, (Exception)((Object)new InferenceException("Insufficient memory available to update source on document [" + indexRequest.getIndexRequest().id() + "]", e, new Object[0])));
                    success = false;
                }
            }
            return success;
        }

        private FieldInferenceResponseAccumulator ensureResponseAccumulatorSlot(int id) {
            FieldInferenceResponseAccumulator acc = (FieldInferenceResponseAccumulator)this.inferenceResults.get(id);
            if (acc == null) {
                acc = new FieldInferenceResponseAccumulator(id, new HashMap<String, List<FieldInferenceResponse>>(), new ArrayList<Exception>());
                this.inferenceResults.set(id, (Object)acc);
            }
            return acc;
        }

        private void addInferenceResponseFailure(int id, Exception failure) {
            FieldInferenceResponseAccumulator acc = this.ensureResponseAccumulatorSlot(id);
            acc.addFailure(failure);
        }

        private void applyInferenceResponses(BulkItemRequest item, FieldInferenceResponseAccumulator response) throws IOException {
            if (!response.failures().isEmpty()) {
                for (Exception failure : response.failures()) {
                    item.abort(item.index(), failure);
                }
                return;
            }
            IndexRequest indexRequest = ShardBulkInferenceActionFilter.getIndexRequestOrNull(item.request());
            HashMap<String, Object> inferenceFieldsMap = new HashMap<String, Object>();
            for (Map.Entry<String, List<FieldInferenceResponse>> entry : response.responses.entrySet()) {
                String fieldName = entry.getKey();
                List<FieldInferenceResponse> responses = entry.getValue();
                Model model = null;
                InferenceFieldMetadata inferenceFieldMetadata = this.fieldInferenceMap.get(fieldName);
                if (inferenceFieldMetadata == null) {
                    throw new IllegalStateException("No inference field metadata for field [" + fieldName + "]");
                }
                Collections.sort(responses, Comparator.comparingInt(FieldInferenceResponse::inputOrder));
                LinkedHashMap<String, List<SemanticTextField.Chunk>> chunkMap = new LinkedHashMap<String, List<SemanticTextField.Chunk>>();
                for (FieldInferenceResponse resp : responses) {
                    if (model == null) {
                        model = resp.model;
                    }
                    List lst = chunkMap.computeIfAbsent(resp.sourceField, k -> new ArrayList());
                    List<SemanticTextField.Chunk> chunks = this.useLegacyFormat ? SemanticTextField.toSemanticTextFieldChunksLegacy(resp.input, resp.chunkedResults, indexRequest.getContentType()) : SemanticTextField.toSemanticTextFieldChunks(resp.offsetAdjustment, resp.chunkedResults, indexRequest.getContentType());
                    lst.addAll(chunks);
                }
                List<String> inputs = this.useLegacyFormat ? responses.stream().filter(r -> r.sourceField().equals(fieldName)).map(r -> r.input).collect(Collectors.toList()) : null;
                SemanticTextField result = new SemanticTextField(this.useLegacyFormat, fieldName, inputs, new SemanticTextField.InferenceResult(inferenceFieldMetadata.getInferenceId(), model != null ? new MinimalServiceSettings(model) : null, ChunkingSettingsBuilder.fromMap(inferenceFieldMetadata.getChunkingSettings(), false), chunkMap), indexRequest.getContentType());
                inferenceFieldsMap.put(fieldName, result);
            }
            BytesReference originalSource = indexRequest.source();
            if (this.useLegacyFormat) {
                Map newDocMap = indexRequest.sourceAsMap();
                for (Map.Entry entry : inferenceFieldsMap.entrySet()) {
                    SemanticTextUtils.insertValue((String)entry.getKey(), newDocMap, entry.getValue());
                }
                indexRequest.source(newDocMap, indexRequest.getContentType());
            } else {
                try (XContentBuilder builder = XContentBuilder.builder((XContent)indexRequest.getContentType().xContent());){
                    ShardBulkInferenceActionFilter.appendSourceAndInferenceMetadata(builder, indexRequest.source(), indexRequest.getContentType(), inferenceFieldsMap);
                    indexRequest.source(builder);
                }
            }
            long modifiedSourceSize = indexRequest.source().length();
            try {
                this.coordinatingIndexingPressure.increment(0, modifiedSourceSize - (long)originalSource.length());
            }
            catch (EsRejectedExecutionException e) {
                indexRequest.source(originalSource, indexRequest.getContentType());
                item.abort(item.index(), (Exception)((Object)new InferenceException("Insufficient memory available to insert inference results into document [" + indexRequest.id() + "]", e, new Object[0])));
            }
        }

        private static class IndexRequestWithIndexingPressure {
            private final IndexRequest indexRequest;
            private boolean indexingPressureIncremented;

            private IndexRequestWithIndexingPressure(IndexRequest indexRequest) {
                this.indexRequest = indexRequest;
                this.indexingPressureIncremented = false;
            }

            private IndexRequest getIndexRequest() {
                return this.indexRequest;
            }

            private boolean isIndexingPressureIncremented() {
                return this.indexingPressureIncremented;
            }

            private void setIndexingPressureIncremented() {
                this.indexingPressureIncremented = true;
            }
        }
    }

    private static class EmptyChunkedInference
    implements ChunkedInference {
        private EmptyChunkedInference() {
        }

        public Iterator<ChunkedInference.Chunk> chunksAsByteReference(XContent xcontent) {
            return Collections.emptyIterator();
        }
    }

    private record FieldInferenceResponseAccumulator(int id, Map<String, List<FieldInferenceResponse>> responses, List<Exception> failures) {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addOrUpdateResponse(FieldInferenceResponse response) {
            FieldInferenceResponseAccumulator fieldInferenceResponseAccumulator = this;
            synchronized (fieldInferenceResponseAccumulator) {
                List list = this.responses.computeIfAbsent(response.field, k -> new ArrayList());
                list.add(response);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addFailure(Exception exc) {
            FieldInferenceResponseAccumulator fieldInferenceResponseAccumulator = this;
            synchronized (fieldInferenceResponseAccumulator) {
                this.failures.add(exc);
            }
        }
    }

    private record FieldInferenceResponse(String field, String sourceField, String input, int inputOrder, int offsetAdjustment, Model model, ChunkedInference chunkedResults) {
    }

    private record FieldInferenceRequest(int bulkItemIndex, String field, String sourceField, String input, int inputOrder, int offsetAdjustment, ChunkingSettings chunkingSettings) {
    }

    private record InferenceProvider(InferenceService service, Model model) {
    }
}

