/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.datafeeds;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsStatsAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.ml.rest.RestCompatibilityChecker;

@ServerlessScope(value=Scope.PUBLIC)
public class RestGetDatafeedStatsAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)("/_ml/datafeeds/{" + String.valueOf(DatafeedConfig.ID) + "}/_stats")).replaces(RestRequest.Method.GET, "/_xpack/ml/datafeeds/{" + String.valueOf(DatafeedConfig.ID) + "}/_stats", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/_ml/datafeeds/_stats").replaces(RestRequest.Method.GET, "/_xpack/ml/datafeeds/_stats", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "ml_get_datafeed_stats_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String datafeedId = restRequest.param(DatafeedConfig.ID.getPreferredName());
        if (Strings.isNullOrEmpty((String)datafeedId)) {
            datafeedId = "_all";
        }
        GetDatafeedsStatsAction.Request request = new GetDatafeedsStatsAction.Request(datafeedId);
        RestCompatibilityChecker.checkAndSetDeprecatedParam("allow_no_datafeeds", "allow_no_match", RestApiVersion.V_7, restRequest, (r, s) -> r.paramAsBoolean(s, request.allowNoMatch()), arg_0 -> ((GetDatafeedsStatsAction.Request)request).setAllowNoMatch(arg_0));
        return channel -> new RestCancellableNodeClient(client, restRequest.getHttpChannel()).execute((ActionType)GetDatafeedsStatsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

