/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.nlp.tokenizers;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.analysis.charfilter.BaseCharFilter;

public class ControlCharFilter
extends BaseCharFilter {
    public static final String NAME = "control_char_filter";
    private Reader transformedInput;

    public ControlCharFilter(Reader in) {
        super(in);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.transformedInput == null) {
            this.fill();
        }
        return this.transformedInput.read(cbuf, off, len);
    }

    public int read() throws IOException {
        if (this.transformedInput == null) {
            this.fill();
        }
        return this.transformedInput.read();
    }

    private void fill() throws IOException {
        ArrayList<char[]> charArrays = new ArrayList<char[]>();
        char[] temp = new char[1024];
        int totalRead = 0;
        int diff = 0;
        int cnt = this.input.read(temp);
        while (cnt > 0) {
            int pos = 0;
            while (pos < cnt) {
                int size;
                int start;
                for (start = pos; start < cnt && ControlCharFilter.isControlChar(temp[start]); ++start) {
                }
                if (start > pos) {
                    this.addOffCorrectMap(pos + totalRead, diff += start - pos);
                }
                for (size = 0; size < cnt - start && !ControlCharFilter.isControlChar(temp[start + size]); ++size) {
                }
                charArrays.add(Arrays.copyOfRange(temp, start, start + size));
                pos = start + size;
            }
            totalRead += cnt;
            cnt = this.input.read(temp);
        }
        char[] wholeArray = new char[charArrays.stream().mapToInt(cs -> ((char[])cs).length).sum()];
        int currIndex = 0;
        for (char[] elements : charArrays) {
            System.arraycopy(elements, 0, wholeArray, currIndex, elements.length);
            currIndex += elements.length;
        }
        this.transformedInput = new CharArrayReader(wholeArray);
    }

    private static boolean isControlChar(char c) {
        if (c == '\n' || c == '\r' || c == '\t') {
            return false;
        }
        int category = Character.getType(c);
        return category >= 15 && category <= 19;
    }
}

