/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisVerificationAware;
import org.elasticsearch.xpack.esql.capabilities.TelemetryAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.SortAgnostic;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;

public class Filter
extends UnaryPlan
implements PostAnalysisVerificationAware,
TelemetryAware,
SortAgnostic {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "Filter", Filter::new);
    private final Expression condition;

    public Filter(Source source, LogicalPlan child, Expression condition) {
        super(source, child);
        this.condition = condition;
    }

    private Filter(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (LogicalPlan)in.readNamedWriteable(LogicalPlan.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        out.writeNamedWriteable((NamedWriteable)this.condition());
    }

    public String getWriteableName() {
        return Filter.ENTRY.name;
    }

    protected NodeInfo<Filter> info() {
        return NodeInfo.create((Node)this, Filter::new, (Object)((Object)this.child()), (Object)this.condition);
    }

    @Override
    public Filter replaceChild(LogicalPlan newChild) {
        return new Filter(this.source(), newChild, this.condition);
    }

    public Expression condition() {
        return this.condition;
    }

    @Override
    public String telemetryLabel() {
        return "WHERE";
    }

    @Override
    public boolean expressionsResolved() {
        return this.condition.resolved();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.condition, this.child()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Filter other = (Filter)obj;
        return Objects.equals(this.condition, other.condition) && Objects.equals((Object)this.child(), (Object)other.child());
    }

    public Filter with(Expression conditionExpr) {
        return new Filter(this.source(), this.child(), conditionExpr);
    }

    public Filter with(LogicalPlan child, Expression conditionExpr) {
        return new Filter(this.source(), child, conditionExpr);
    }

    @Override
    public void postAnalysisVerification(Failures failures) {
        Filter.checkFilterConditionDataType(this.condition, failures);
    }

    public static void checkFilterConditionDataType(Expression expression, Failures failures) {
        if (expression.dataType() != DataType.NULL && expression.dataType() != DataType.BOOLEAN) {
            failures.add(Failure.fail(expression, "Condition expression needs to be boolean, found [{}]", new Object[]{expression.dataType()}));
        }
    }
}

