/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.CountAggregatorFunction;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlockBuilder;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Sum;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.FromAggregateMetricDouble;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvCount;
import org.elasticsearch.xpack.esql.expression.function.scalar.nulls.Coalesce;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Mul;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class Count
extends AggregateFunction
implements ToAggregator,
SurrogateExpression {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Count", Count::new);

    @FunctionInfo(returnType={"long"}, description="Returns the total number (count) of input values.", isAggregation=true, examples={@Example(file="stats", tag="count"), @Example(description="To count the number of rows, use `COUNT()` or `COUNT(*)`", file="docs", tag="countAll"), @Example(description="The expression can use inline functions. This example splits a string into multiple values using the `SPLIT` function and counts the values", file="stats", tag="docsCountWithExpression"), @Example(description="To count the number of times an expression returns `TRUE` use a <<esql-where>> command to remove rows that shouldn't be included", file="stats", tag="count-where"), @Example(description="To count the same stream of data based on two different expressions use the pattern `COUNT(<expression> OR NULL)`. This builds on the three-valued logic ({wikipedia}/Three-valued_logic[3VL]) of the language: `TRUE OR NULL` is `TRUE`, but `FALSE OR NULL` is `NULL`, plus the way COUNT handles `NULL`s: `COUNT(TRUE)` and `COUNT(FALSE)` are both 1, but `COUNT(NULL)` is 0.", file="stats", tag="count-or-null")})
    public Count(Source source, @Param(optional=true, name="field", type={"aggregate_metric_double", "boolean", "cartesian_point", "date", "double", "geo_point", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="Expression that outputs values to be counted. If omitted, equivalent to `COUNT(*)` (the number of rows).") Expression field) {
        this(source, field, (Expression)Literal.TRUE);
    }

    public Count(Source source, Expression field, Expression filter) {
        super(source, field, filter, Collections.emptyList());
    }

    private Count(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Count.ENTRY.name;
    }

    protected NodeInfo<Count> info() {
        return NodeInfo.create((Node)this, Count::new, (Object)this.field(), (Object)this.filter());
    }

    @Override
    public AggregateFunction withFilter(Expression filter) {
        return new Count(this.source(), this.field(), filter);
    }

    public Count replaceChildren(List<Expression> newChildren) {
        return new Count(this.source(), newChildren.get(0), newChildren.get(1));
    }

    public DataType dataType() {
        return DataType.LONG;
    }

    @Override
    public AggregatorFunctionSupplier supplier() {
        return CountAggregatorFunction.supplier();
    }

    public Nullability nullable() {
        return Nullability.FALSE;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType((Expression)this.field(), dt -> !dt.isCounter(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"any type except counter types"});
    }

    @Override
    public Expression surrogate() {
        Source s = this.source();
        Expression field = this.field();
        if (field.dataType() == DataType.AGGREGATE_METRIC_DOUBLE) {
            return new Sum(s, (Expression)FromAggregateMetricDouble.withMetric(this.source(), field, AggregateMetricDoubleBlockBuilder.Metric.COUNT), this.filter());
        }
        if (field.foldable()) {
            Literal l;
            if (field instanceof Literal && (l = (Literal)field).value() != null && !(l.value() instanceof List)) {
                return null;
            }
            return new Mul(s, (Expression)new Coalesce(s, (Expression)new MvCount(s, field), List.of(new Literal(s, (Object)0, DataType.INTEGER))), (Expression)new Count(s, (Expression)Literal.keyword((Source)s, (String)"*"), this.filter()));
        }
        return null;
    }
}

