/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation.logging;

import java.util.Objects;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xcontent.XContentType;

@Plugin(name="DeprecationIndexingAppender", category="Core", elementType="appender")
public class DeprecationIndexingAppender
extends AbstractAppender {
    private static final Logger logger = LogManager.getLogger(DeprecationIndexingAppender.class);
    public static final String DEPRECATION_MESSAGES_DATA_STREAM = ".logs-deprecation.elasticsearch-default";
    private final Consumer<IndexRequest> requestConsumer;
    private volatile boolean isEnabled = false;

    public DeprecationIndexingAppender(String name, Filter filter, Layout<String> layout, Consumer<IndexRequest> requestConsumer) {
        super(name, filter, layout);
        this.requestConsumer = Objects.requireNonNull(requestConsumer, "requestConsumer cannot be null");
    }

    public void append(LogEvent event) {
        logger.trace(() -> Strings.format((String)"Received deprecation log event. Appender is %s. message = %s", (Object[])new Object[]{this.isEnabled ? "enabled" : "disabled", event.getMessage().getFormattedMessage()}));
        if (!this.isEnabled) {
            return;
        }
        byte[] payload = this.getLayout().toByteArray(event);
        IndexRequest request = new IndexRequest(DEPRECATION_MESSAGES_DATA_STREAM).source(payload, XContentType.JSON).opType(DocWriteRequest.OpType.CREATE);
        this.requestConsumer.accept(request);
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }
}

