/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.template;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.xcontent.XContentType;

public abstract class IngestPipelineConfig {
    protected final String id;
    protected final String resource;
    protected final int version;
    protected final String versionProperty;
    protected final Map<String, String> variables;
    private final List<String> dependencies;

    public IngestPipelineConfig(String id, String resource, int version, String versionProperty) {
        this(id, resource, version, versionProperty, Collections.emptyList());
    }

    public IngestPipelineConfig(String id, String resource, int version, String versionProperty, List<String> dependencies) {
        this(id, resource, version, versionProperty, dependencies, Map.of());
    }

    public IngestPipelineConfig(String id, String resource, int version, String versionProperty, List<String> dependencies, Map<String, String> variables) {
        this.id = Objects.requireNonNull(id);
        this.resource = Objects.requireNonNull(resource);
        this.version = version;
        this.versionProperty = Objects.requireNonNull(versionProperty);
        this.dependencies = dependencies;
        this.variables = Objects.requireNonNull(variables);
    }

    public String getId() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public List<String> getPipelineDependencies() {
        return this.dependencies;
    }

    public abstract XContentType getXContentType();

    public abstract BytesReference loadConfig();
}

