/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.TooComplexToDeterminizeException;
import org.elasticsearch.action.admin.indices.mapping.put.TransportAutoPutMappingAction;
import org.elasticsearch.action.admin.indices.mapping.put.TransportPutMappingAction;
import org.elasticsearch.action.support.IndexComponentSelector;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.security.authz.RestrictedIndices;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.DocumentPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivilegesMap;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexComponentSelectorPredicate;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.core.security.support.Automatons;
import org.elasticsearch.xpack.core.security.support.StringMatcher;

public final class IndicesPermission {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(IndicesPermission.class);
    public static final IndicesPermission NONE = new IndicesPermission(new RestrictedIndices(Automatons.EMPTY), Group.EMPTY_ARRAY);
    private static final Set<String> PRIVILEGE_NAME_SET_BWC_ALLOW_MAPPING_UPDATE = Set.of("create", "create_doc", "index", "write");
    private final Map<String, IsResourceAuthorizedPredicate> allowedIndicesMatchersForAction = new ConcurrentHashMap<String, IsResourceAuthorizedPredicate>();
    private final RestrictedIndices restrictedIndices;
    private final Group[] groups;
    private final boolean hasFieldOrDocumentLevelSecurity;

    private IndicesPermission(RestrictedIndices restrictedIndices, Group[] groups) {
        this.restrictedIndices = restrictedIndices;
        this.groups = groups;
        this.hasFieldOrDocumentLevelSecurity = Arrays.stream(groups).noneMatch(Group::isTotal) && Arrays.stream(groups).anyMatch(g -> g.hasQuery() || g.fieldPermissions.hasFieldLevelSecurity());
    }

    private StringMatcher indexMatcher(Collection<String> ordinaryIndices, Collection<String> restrictedIndices) {
        Predicate<String> matcher;
        if (ordinaryIndices.isEmpty()) {
            matcher = StringMatcher.of(restrictedIndices);
        } else {
            matcher = StringMatcher.of(ordinaryIndices);
            if (this.restrictedIndices != null) {
                matcher = matcher.and("<not-restricted>", name -> !this.restrictedIndices.isRestricted((String)name));
            }
            if (!restrictedIndices.isEmpty()) {
                matcher = StringMatcher.of(restrictedIndices).or(matcher);
            }
        }
        return matcher;
    }

    public Group[] groups() {
        return this.groups;
    }

    public IsResourceAuthorizedPredicate allowedIndicesMatcher(String action) {
        return this.allowedIndicesMatchersForAction.computeIfAbsent(action, this::buildIndexMatcherPredicateForAction);
    }

    public boolean hasFieldOrDocumentLevelSecurity() {
        return this.hasFieldOrDocumentLevelSecurity;
    }

    private IsResourceAuthorizedPredicate buildIndexMatcherPredicateForAction(String action) {
        HashSet<String> dataAccessOrdinaryIndices = new HashSet<String>();
        HashSet<String> failuresAccessOrdinaryIndices = new HashSet<String>();
        HashSet<String> dataAccessRestrictedIndices = new HashSet<String>();
        HashSet<String> failuresAccessRestrictedIndices = new HashSet<String>();
        HashSet<String> grantMappingUpdatesOnIndices = new HashSet<String>();
        HashSet<String> grantMappingUpdatesOnRestrictedIndices = new HashSet<String>();
        boolean isMappingUpdateAction = IndicesPermission.isMappingUpdateAction(action);
        for (Group group : this.groups) {
            if (group.actionMatcher.test(action)) {
                List<String> indexList = Arrays.asList(group.indices());
                boolean dataAccess = group.checkSelector(IndexComponentSelector.DATA);
                boolean failuresAccess = group.checkSelector(IndexComponentSelector.FAILURES);
                assert (dataAccess || failuresAccess) : "group must grant access at least one of [DATA, FAILURES] selectors";
                if (group.allowRestrictedIndices) {
                    if (dataAccess) {
                        dataAccessRestrictedIndices.addAll(indexList);
                    }
                    if (!failuresAccess) continue;
                    failuresAccessRestrictedIndices.addAll(indexList);
                    continue;
                }
                if (dataAccess) {
                    dataAccessOrdinaryIndices.addAll(indexList);
                }
                if (!failuresAccess) continue;
                failuresAccessOrdinaryIndices.addAll(indexList);
                continue;
            }
            if (!isMappingUpdateAction || !IndicesPermission.containsPrivilegeThatGrantsMappingUpdatesForBwc(group)) continue;
            if (group.allowRestrictedIndices) {
                grantMappingUpdatesOnRestrictedIndices.addAll(Arrays.asList(group.indices()));
                continue;
            }
            grantMappingUpdatesOnIndices.addAll(Arrays.asList(group.indices()));
        }
        StringMatcher dataAccessNameMatcher = this.indexMatcher(dataAccessOrdinaryIndices, dataAccessRestrictedIndices);
        StringMatcher failuresAccessNameMatcher = this.indexMatcher(failuresAccessOrdinaryIndices, failuresAccessRestrictedIndices);
        StringMatcher bwcSpecialCaseMatcher = this.indexMatcher(grantMappingUpdatesOnIndices, grantMappingUpdatesOnRestrictedIndices);
        return new IsResourceAuthorizedPredicate(dataAccessNameMatcher, failuresAccessNameMatcher, bwcSpecialCaseMatcher);
    }

    public boolean check(String action) {
        boolean isMappingUpdateAction = IndicesPermission.isMappingUpdateAction(action);
        for (Group group : this.groups) {
            if (!group.checkAction(action) && (!isMappingUpdateAction || !IndicesPermission.containsPrivilegeThatGrantsMappingUpdatesForBwc(group))) continue;
            return true;
        }
        return false;
    }

    public boolean checkResourcePrivileges(Set<String> checkForIndexPatterns, boolean allowRestrictedIndices, Set<String> checkForPrivileges, @Nullable ResourcePrivilegesMap.Builder resourcePrivilegesMapBuilder) {
        return this.checkResourcePrivileges(checkForIndexPatterns, allowRestrictedIndices, checkForPrivileges, false, resourcePrivilegesMapBuilder);
    }

    public boolean checkResourcePrivileges(Set<String> checkForIndexPatterns, boolean allowRestrictedIndices, Set<String> checkForPrivileges, boolean combineIndexGroups, @Nullable ResourcePrivilegesMap.Builder resourcePrivilegesMapBuilder) {
        boolean allMatch = true;
        Map<Automaton, Automaton> indexGroupAutomatonsForDataSelector = this.indexGroupAutomatons(combineIndexGroups && checkForIndexPatterns.stream().anyMatch(Automatons::isLuceneRegex), IndexComponentSelector.DATA);
        boolean containsPrivilegesForFailuresSelector = IndicesPermission.containsPrivilegesForFailuresSelector(checkForPrivileges);
        Map<Automaton, Automaton> indexGroupAutomatonsForFailuresSelector = false == containsPrivilegesForFailuresSelector ? Map.of() : this.indexGroupAutomatons(combineIndexGroups && checkForIndexPatterns.stream().anyMatch(Automatons::isLuceneRegex), IndexComponentSelector.FAILURES);
        Map checkIndexPatterns = checkForIndexPatterns.stream().collect(Collectors.toMap(Function.identity(), pattern -> {
            try {
                Automaton automaton = Automatons.patterns(pattern);
                if (!allowRestrictedIndices && !this.isConcreteRestrictedIndex((String)pattern)) {
                    automaton = Automatons.minusAndMinimize(automaton, this.restrictedIndices.getAutomaton());
                }
                return automaton;
            }
            catch (TooComplexToDeterminizeException e) {
                String text = pattern.length() > 260 ? Strings.cleanTruncate((String)pattern, (int)256) + "..." : pattern;
                this.logger.info("refusing to check privileges against complex index pattern [{}]", (Object)text);
                throw new IllegalArgumentException("the provided index pattern [" + text + "] is too complex to be evaluated", e);
            }
        }));
        for (Map.Entry entry : checkIndexPatterns.entrySet()) {
            String forIndexPattern = (String)entry.getKey();
            Automaton checkIndexAutomaton = entry.getValue();
            if (!Operations.isEmpty((Automaton)checkIndexAutomaton)) {
                Automaton allowedPrivilegesAutomatonForDataSelector = IndicesPermission.getIndexPrivilegesAutomaton(indexGroupAutomatonsForDataSelector, checkIndexAutomaton);
                Automaton allowedPrivilegesAutomatonForFailuresSelector = IndicesPermission.getIndexPrivilegesAutomaton(indexGroupAutomatonsForFailuresSelector, checkIndexAutomaton);
                for (String privilege : checkForPrivileges) {
                    IndexPrivilege indexPrivilege = IndexPrivilege.get(privilege);
                    boolean checkWithDataSelector = indexPrivilege.getSelectorPredicate().test(IndexComponentSelector.DATA);
                    boolean checkWithFailuresSelector = indexPrivilege.getSelectorPredicate().test(IndexComponentSelector.FAILURES);
                    assert (checkWithDataSelector || checkWithFailuresSelector) : "index privilege must map to at least one of [data, failures] selectors";
                    assert (containsPrivilegesForFailuresSelector || indexPrivilege.getSelectorPredicate() != IndexComponentSelectorPredicate.FAILURES) : "no failures access privileges should be present in the set of privileges to check";
                    Automaton automatonToCheck = indexPrivilege.getAutomaton();
                    if (checkWithDataSelector && allowedPrivilegesAutomatonForDataSelector != null && Operations.subsetOf((Automaton)automatonToCheck, (Automaton)allowedPrivilegesAutomatonForDataSelector)) {
                        if (resourcePrivilegesMapBuilder == null) continue;
                        resourcePrivilegesMapBuilder.addResourcePrivilege(forIndexPattern, privilege, Boolean.TRUE);
                        continue;
                    }
                    if (checkWithFailuresSelector && allowedPrivilegesAutomatonForFailuresSelector != null && Operations.subsetOf((Automaton)automatonToCheck, (Automaton)allowedPrivilegesAutomatonForFailuresSelector)) {
                        if (resourcePrivilegesMapBuilder == null) continue;
                        resourcePrivilegesMapBuilder.addResourcePrivilege(forIndexPattern, privilege, Boolean.TRUE);
                        continue;
                    }
                    if (resourcePrivilegesMapBuilder != null) {
                        resourcePrivilegesMapBuilder.addResourcePrivilege(forIndexPattern, privilege, Boolean.FALSE);
                        allMatch = false;
                        continue;
                    }
                    return false;
                }
                continue;
            }
            if (resourcePrivilegesMapBuilder != null) {
                for (String privilege : checkForPrivileges) {
                    resourcePrivilegesMapBuilder.addResourcePrivilege(forIndexPattern, privilege, Boolean.FALSE);
                }
                allMatch = false;
                continue;
            }
            return false;
        }
        return allMatch;
    }

    public Automaton allowedActionsMatcher(String index) {
        Tuple tuple = IndexNameExpressionResolver.splitSelectorExpression((String)index);
        String indexName = (String)tuple.v1();
        IndexComponentSelector selector = IndexComponentSelector.getByKey((String)((String)tuple.v2()));
        ArrayList<Automaton> automatonList = new ArrayList<Automaton>();
        for (Group group : this.groups) {
            if (!group.checkSelector(selector) || !group.indexNameMatcher.test(indexName)) continue;
            automatonList.add(group.privilege.getAutomaton());
        }
        return automatonList.isEmpty() ? Automatons.EMPTY : Automatons.unionAndMinimize(automatonList);
    }

    public IndicesAccessControl authorize(String action, Set<String> requestedIndicesOrAliases, Metadata metadata, FieldPermissionsCache fieldPermissionsCache) {
        for (Group group : this.groups) {
            if (!group.isTotal()) continue;
            return IndicesAccessControl.allowAll();
        }
        Map resources = Maps.newMapWithExpectedSize((int)requestedIndicesOrAliases.size());
        int totalResourceCount = 0;
        SortedMap lookup = metadata.getIndicesLookup();
        for (String indexOrAlias : requestedIndicesOrAliases) {
            Tuple expressionAndSelector = IndexNameExpressionResolver.splitSelectorExpression((String)indexOrAlias);
            indexOrAlias = (String)expressionAndSelector.v1();
            IndexComponentSelector selector = expressionAndSelector.v2() == null ? null : IndexComponentSelector.getByKey((String)((String)expressionAndSelector.v2()));
            IndexResource resource = new IndexResource(indexOrAlias, (IndexAbstraction)lookup.get(indexOrAlias), selector);
            resources.put(resource.nameWithSelector(), resource);
            totalResourceCount += resource.size(lookup);
        }
        boolean overallGranted = this.isActionGranted(action, resources.values());
        int finalTotalResourceCount = totalResourceCount;
        Supplier<Map<String, IndicesAccessControl.IndexAccessControl>> indexPermissions = () -> this.buildIndicesAccessControl(action, resources, finalTotalResourceCount, fieldPermissionsCache, metadata);
        return new IndicesAccessControl(overallGranted, indexPermissions);
    }

    private Map<String, IndicesAccessControl.IndexAccessControl> buildIndicesAccessControl(String action, Map<String, IndexResource> requestedResources, int totalResourceCount, FieldPermissionsCache fieldPermissionsCache, Metadata metadata) {
        Map fieldPermissionsByIndex = Maps.newMapWithExpectedSize((int)totalResourceCount);
        Map roleQueriesByIndex = Maps.newMapWithExpectedSize((int)totalResourceCount);
        HashSet grantedResources = Sets.newHashSetWithExpectedSize((int)totalResourceCount);
        boolean isMappingUpdateAction = IndicesPermission.isMappingUpdateAction(action);
        for (Map.Entry<String, IndexResource> resourceEntry : requestedResources.entrySet()) {
            boolean granted = false;
            String resourceName = resourceEntry.getKey();
            IndexResource resource = resourceEntry.getValue();
            Collection<String> concreteIndices = resource.resolveConcreteIndices(metadata);
            for (Group group : this.groups) {
                if (!resource.checkIndex(group) || !group.checkAction(action) && (!isMappingUpdateAction || resource.isPartOfDataStream() || !IndicesPermission.containsPrivilegeThatGrantsMappingUpdatesForBwc(group))) continue;
                granted = true;
                for (String index : concreteIndices) {
                    DocumentLevelPermissions docPermissions;
                    Set fieldPermissions = fieldPermissionsByIndex.compute(index, (k, existingSet) -> {
                        if (existingSet == null) {
                            return Set.of(group.getFieldPermissions());
                        }
                        if (existingSet.size() == 1) {
                            FieldPermissions fp = group.getFieldPermissions();
                            if (existingSet.contains(fp)) {
                                return existingSet;
                            }
                            HashSet<FieldPermissions> hashSet = new HashSet<FieldPermissions>((Collection<FieldPermissions>)existingSet);
                            hashSet.add(fp);
                            return hashSet;
                        }
                        existingSet.add(group.getFieldPermissions());
                        return existingSet;
                    });
                    if (group.hasQuery()) {
                        docPermissions = roleQueriesByIndex.computeIfAbsent(index, k -> new DocumentLevelPermissions());
                        docPermissions.addAll(group.getQuery());
                    } else {
                        docPermissions = DocumentLevelPermissions.ALLOW_ALL;
                        roleQueriesByIndex.put(index, docPermissions);
                    }
                    if (index.equals(resourceName)) continue;
                    fieldPermissionsByIndex.put(resourceName, fieldPermissions);
                    roleQueriesByIndex.put(resourceName, docPermissions);
                }
            }
            if (!granted) continue;
            grantedResources.add(resourceName);
            if (!resource.canHaveBackingIndices()) continue;
            for (String concreteIndex : concreteIndices) {
                if (requestedResources.containsKey(concreteIndex)) continue;
                grantedResources.add(concreteIndex);
            }
        }
        Map indexPermissions = Maps.newMapWithExpectedSize((int)grantedResources.size());
        for (String index : grantedResources) {
            DocumentLevelPermissions permissions = (DocumentLevelPermissions)roleQueriesByIndex.get(index);
            DocumentPermissions documentPermissions = permissions != null && !permissions.isAllowAll() ? DocumentPermissions.filteredBy(permissions.queries) : DocumentPermissions.allowAll();
            Set indexFieldPermissions = (Set)fieldPermissionsByIndex.get(index);
            FieldPermissions fieldPermissions = indexFieldPermissions != null && !indexFieldPermissions.isEmpty() ? (indexFieldPermissions.size() == 1 ? (FieldPermissions)indexFieldPermissions.iterator().next() : fieldPermissionsCache.union(indexFieldPermissions)) : FieldPermissions.DEFAULT;
            indexPermissions.put(index, new IndicesAccessControl.IndexAccessControl(fieldPermissions, documentPermissions));
        }
        return Collections.unmodifiableMap(indexPermissions);
    }

    private boolean isActionGranted(String action, Collection<IndexResource> requestedResources) {
        boolean isMappingUpdateAction = IndicesPermission.isMappingUpdateAction(action);
        for (IndexResource resource : requestedResources) {
            boolean granted = false;
            boolean bwcGrantMappingUpdate = false;
            ArrayList<Runnable> bwcDeprecationLogActions = new ArrayList<Runnable>();
            for (Group group : this.groups) {
                if (!resource.checkIndex(group)) continue;
                boolean actionCheck = group.checkAction(action);
                if (actionCheck) {
                    granted = true;
                    break;
                }
                boolean bwcMappingActionCheck = isMappingUpdateAction && false == resource.isPartOfDataStream() && IndicesPermission.containsPrivilegeThatGrantsMappingUpdatesForBwc(group);
                boolean bl = bwcGrantMappingUpdate = bwcGrantMappingUpdate || bwcMappingActionCheck;
                if (!bwcMappingActionCheck) continue;
                IndicesPermission.logDeprecatedBwcPrivilegeUsage(action, resource, group, bwcDeprecationLogActions);
            }
            if (!granted && bwcGrantMappingUpdate) {
                granted = true;
                bwcDeprecationLogActions.forEach(Runnable::run);
            }
            if (granted) continue;
            return false;
        }
        return true;
    }

    private static void logDeprecatedBwcPrivilegeUsage(String action, IndexResource resource, Group group, List<Runnable> bwcDeprecationLogActions) {
        for (String privilegeName : group.privilege.name()) {
            if (!PRIVILEGE_NAME_SET_BWC_ALLOW_MAPPING_UPDATE.contains(privilegeName)) continue;
            bwcDeprecationLogActions.add(() -> deprecationLogger.warn(DeprecationCategory.SECURITY, "[" + resource.name + "] mapping update for ingest privilege [" + privilegeName + "]", "the index privilege [" + privilegeName + "] allowed the update mapping action [" + action + "] on index [" + resource.name + "], this privilege will not permit mapping updates in the next major release - users who require access to update mappings must be granted explicit privileges", new Object[0]));
        }
    }

    private boolean isConcreteRestrictedIndex(String indexPattern) {
        if (Regex.isSimpleMatchPattern((String)indexPattern) || Automatons.isLuceneRegex(indexPattern)) {
            return false;
        }
        return this.restrictedIndices.isRestricted(indexPattern);
    }

    private static boolean isMappingUpdateAction(String action) {
        return action.equals(TransportPutMappingAction.TYPE.name()) || action.equals(TransportAutoPutMappingAction.TYPE.name());
    }

    private static boolean containsPrivilegeThatGrantsMappingUpdatesForBwc(Group group) {
        return group.privilege().name().stream().anyMatch(PRIVILEGE_NAME_SET_BWC_ALLOW_MAPPING_UPDATE::contains);
    }

    private Map<Automaton, Automaton> indexGroupAutomatons(boolean combine, IndexComponentSelector selector) {
        HashMap<Automaton, Automaton> allAutomatons = new HashMap<Automaton, Automaton>();
        for (Group group : this.groups) {
            if (!group.checkSelector(selector)) continue;
            Automaton indexAutomaton = group.getIndexMatcherAutomaton();
            allAutomatons.compute(group.privilege().getAutomaton(), (key, value) -> value == null ? indexAutomaton : Automatons.unionAndMinimize(List.of(value, indexAutomaton)));
            if (!combine) continue;
            ArrayList<Tuple> combinedAutomatons = new ArrayList<Tuple>();
            for (Map.Entry indexAndPrivilegeAutomatons : allAutomatons.entrySet()) {
                Automaton intersectingPrivileges = Operations.intersection((Automaton)((Automaton)indexAndPrivilegeAutomatons.getKey()), (Automaton)group.privilege().getAutomaton());
                if (Operations.isEmpty((Automaton)intersectingPrivileges)) continue;
                Automaton indexPatternAutomaton = Automatons.unionAndMinimize(List.of((Automaton)indexAndPrivilegeAutomatons.getValue(), indexAutomaton));
                combinedAutomatons.add(new Tuple((Object)intersectingPrivileges, (Object)indexPatternAutomaton));
            }
            combinedAutomatons.forEach(automatons -> allAutomatons.compute((Automaton)automatons.v1(), (key, value) -> value == null ? (Automaton)automatons.v2() : Automatons.unionAndMinimize(List.of(value, (Automaton)automatons.v2()))));
        }
        return allAutomatons;
    }

    private static boolean containsPrivilegesForFailuresSelector(Set<String> checkForPrivileges) {
        for (String privilege : checkForPrivileges) {
            IndexPrivilege named = IndexPrivilege.getNamedOrNull(privilege);
            if (named == null || named.getSelectorPredicate() != IndexComponentSelectorPredicate.FAILURES) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static Automaton getIndexPrivilegesAutomaton(Map<Automaton, Automaton> indexGroupAutomatons, Automaton checkIndexAutomaton) {
        if (indexGroupAutomatons.isEmpty()) {
            return null;
        }
        Automaton allowedPrivilegesAutomaton = null;
        for (Map.Entry<Automaton, Automaton> indexAndPrivilegeAutomaton : indexGroupAutomatons.entrySet()) {
            Automaton indexNameAutomaton = indexAndPrivilegeAutomaton.getValue();
            if (!Operations.subsetOf((Automaton)checkIndexAutomaton, (Automaton)indexNameAutomaton)) continue;
            Automaton privilegesAutomaton = indexAndPrivilegeAutomaton.getKey();
            if (allowedPrivilegesAutomaton != null) {
                allowedPrivilegesAutomaton = Automatons.unionAndMinimize(Arrays.asList(allowedPrivilegesAutomaton, privilegesAutomaton));
                continue;
            }
            allowedPrivilegesAutomaton = privilegesAutomaton;
        }
        return allowedPrivilegesAutomaton;
    }

    public static class Group {
        public static final Group[] EMPTY_ARRAY = new Group[0];
        private final IndexPrivilege privilege;
        private final IndexComponentSelectorPredicate selectorPredicate;
        private final Predicate<String> actionMatcher;
        private final String[] indices;
        private final StringMatcher indexNameMatcher;
        private final Supplier<Automaton> indexNameAutomaton;
        private final FieldPermissions fieldPermissions;
        private final Set<BytesReference> query;
        private final boolean allowRestrictedIndices;

        public Group(IndexPrivilege privilege, FieldPermissions fieldPermissions, @Nullable Set<BytesReference> query, boolean allowRestrictedIndices, RestrictedIndices restrictedIndices, String ... indices) {
            assert (indices.length != 0);
            this.privilege = privilege;
            this.actionMatcher = privilege.predicate();
            this.selectorPredicate = privilege.getSelectorPredicate();
            this.indices = indices;
            this.allowRestrictedIndices = allowRestrictedIndices;
            ConcurrentHashMap indexNameAutomatonMemo = new ConcurrentHashMap(1);
            if (allowRestrictedIndices) {
                this.indexNameMatcher = StringMatcher.of(indices);
                this.indexNameAutomaton = () -> indexNameAutomatonMemo.computeIfAbsent(indices, k -> Automatons.patterns(indices));
            } else {
                this.indexNameMatcher = StringMatcher.of(indices).and(name -> !restrictedIndices.isRestricted((String)name));
                this.indexNameAutomaton = () -> indexNameAutomatonMemo.computeIfAbsent(indices, k -> Automatons.minusAndMinimize(Automatons.patterns(indices), restrictedIndices.getAutomaton()));
            }
            this.fieldPermissions = Objects.requireNonNull(fieldPermissions);
            this.query = query;
        }

        public IndexPrivilege privilege() {
            return this.privilege;
        }

        public String[] indices() {
            return this.indices;
        }

        @Nullable
        public Set<BytesReference> getQuery() {
            return this.query;
        }

        public FieldPermissions getFieldPermissions() {
            return this.fieldPermissions;
        }

        private boolean checkAction(String action) {
            return this.actionMatcher.test(action);
        }

        private boolean checkIndex(String index) {
            assert (index != null);
            return this.indexNameMatcher.test(index);
        }

        boolean hasQuery() {
            return this.query != null;
        }

        public boolean checkSelector(@Nullable IndexComponentSelector selector) {
            return this.selectorPredicate.test(selector == null ? IndexComponentSelector.DATA : selector);
        }

        public boolean allowRestrictedIndices() {
            return this.allowRestrictedIndices;
        }

        public Automaton getIndexMatcherAutomaton() {
            return this.indexNameAutomaton.get();
        }

        boolean isTotal() {
            return this.allowRestrictedIndices && this.indexNameMatcher.isTotal() && this.privilege == IndexPrivilege.ALL && this.query == null && false == this.fieldPermissions.hasFieldLevelSecurity();
        }

        public String toString() {
            return "Group{privilege=" + String.valueOf(this.privilege) + ", indices=" + Strings.arrayToCommaDelimitedString((Object[])this.indices) + ", fieldPermissions=" + String.valueOf(this.fieldPermissions) + ", query=" + String.valueOf(this.query) + ", allowRestrictedIndices=" + this.allowRestrictedIndices + "}";
        }
    }

    public static class IsResourceAuthorizedPredicate {
        private final BiPredicate<String, IndexAbstraction> isAuthorizedForDataAccess;
        private final BiPredicate<String, IndexAbstraction> isAuthorizedForFailuresAccess;

        public IsResourceAuthorizedPredicate(StringMatcher dataResourceNameMatcher, StringMatcher failuresResourceNameMatcher, StringMatcher additionalNonDatastreamNameMatcher) {
            this((name, indexAbstraction) -> {
                assert (indexAbstraction == null || name.equals(indexAbstraction.getName()));
                return dataResourceNameMatcher.test((String)name) || !IsResourceAuthorizedPredicate.isPartOfDatastream(indexAbstraction) && additionalNonDatastreamNameMatcher.test((String)name);
            }, (name, indexAbstraction) -> {
                assert (indexAbstraction == null || name.equals(indexAbstraction.getName()));
                return failuresResourceNameMatcher.test((String)name);
            });
        }

        private IsResourceAuthorizedPredicate(BiPredicate<String, IndexAbstraction> isAuthorizedForDataAccess, BiPredicate<String, IndexAbstraction> isAuthorizedForFailuresAccess) {
            this.isAuthorizedForDataAccess = isAuthorizedForDataAccess;
            this.isAuthorizedForFailuresAccess = isAuthorizedForFailuresAccess;
        }

        public final IsResourceAuthorizedPredicate and(IsResourceAuthorizedPredicate other) {
            return new IsResourceAuthorizedPredicate(this.isAuthorizedForDataAccess.and(other.isAuthorizedForDataAccess), this.isAuthorizedForFailuresAccess.and(other.isAuthorizedForFailuresAccess));
        }

        public boolean test(IndexAbstraction indexAbstraction) {
            return this.test(indexAbstraction.getName(), indexAbstraction, IndexComponentSelector.DATA);
        }

        public boolean test(IndexAbstraction indexAbstraction, IndexComponentSelector selector) {
            return this.test(indexAbstraction.getName(), indexAbstraction, selector);
        }

        public boolean test(String name, @Nullable IndexAbstraction indexAbstraction, IndexComponentSelector selector) {
            return IndexComponentSelector.FAILURES.equals((Object)selector) ? this.isAuthorizedForFailuresAccess.test(name, indexAbstraction) : this.isAuthorizedForDataAccess.test(name, indexAbstraction);
        }

        private static boolean isPartOfDatastream(IndexAbstraction indexAbstraction) {
            return indexAbstraction != null && (indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM || indexAbstraction.getParentDataStream() != null);
        }
    }

    private static class IndexResource {
        private final String name;
        @Nullable
        private final IndexComponentSelector selector;
        @Nullable
        private final IndexAbstraction indexAbstraction;

        private IndexResource(String name, @Nullable IndexAbstraction abstraction, @Nullable IndexComponentSelector selector) {
            assert (name != null) : "Resource name cannot be null";
            assert (abstraction == null || abstraction.getName().equals(name)) : "Index abstraction has unexpected name [" + abstraction.getName() + "] vs [" + name + "]";
            this.name = name;
            this.indexAbstraction = abstraction;
            this.selector = selector;
        }

        public boolean isPartOfDataStream() {
            if (this.indexAbstraction == null) {
                return false;
            }
            return switch (this.indexAbstraction.getType()) {
                case IndexAbstraction.Type.DATA_STREAM -> true;
                case IndexAbstraction.Type.CONCRETE_INDEX -> {
                    if (this.indexAbstraction.getParentDataStream() != null) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        public boolean checkIndex(Group group) {
            DataStream ds;
            DataStream dataStream = ds = this.indexAbstraction == null ? null : this.indexAbstraction.getParentDataStream();
            if (ds != null && (this.indexAbstraction.isFailureIndexOfDataStream() ? group.checkSelector(IndexComponentSelector.FAILURES) && group.checkIndex(ds.getName()) : (IndexComponentSelector.DATA.equals((Object)this.selector) || this.selector == null) && group.checkSelector(IndexComponentSelector.DATA) && group.checkIndex(ds.getName()))) {
                return true;
            }
            return group.checkSelector(this.selector) && group.checkIndex(this.name);
        }

        public int size(Map<String, IndexAbstraction> lookup) {
            if (this.indexAbstraction == null) {
                return 1;
            }
            if (this.indexAbstraction.getType() == IndexAbstraction.Type.CONCRETE_INDEX) {
                return 1;
            }
            if (this.selector != null) {
                int size = 1;
                if (this.selector.shouldIncludeData()) {
                    size += this.indexAbstraction.getIndices().size();
                }
                if (this.selector.shouldIncludeFailures()) {
                    if (IndexAbstraction.Type.ALIAS.equals((Object)this.indexAbstraction.getType())) {
                        HashSet<DataStream> aliasDataStreams = new HashSet<DataStream>();
                        int failureIndices = 0;
                        for (Index index : this.indexAbstraction.getIndices()) {
                            DataStream parentDataStream = lookup.get(index.getName()).getParentDataStream();
                            if (parentDataStream == null || !aliasDataStreams.add(parentDataStream)) continue;
                            failureIndices += parentDataStream.getFailureIndices().size();
                        }
                        size += failureIndices;
                    } else {
                        DataStream parentDataStream = (DataStream)this.indexAbstraction;
                        size += parentDataStream.getFailureIndices().size();
                    }
                }
                return size;
            }
            return 1 + this.indexAbstraction.getIndices().size();
        }

        public Collection<String> resolveConcreteIndices(Metadata metadata) {
            if (this.indexAbstraction == null) {
                return List.of();
            }
            if (this.indexAbstraction.getType() == IndexAbstraction.Type.CONCRETE_INDEX) {
                return List.of(this.indexAbstraction.getName());
            }
            if (IndexComponentSelector.FAILURES.equals((Object)this.selector)) {
                List failureIndices = this.indexAbstraction.getFailureIndices(metadata);
                ArrayList<String> concreteIndexNames = new ArrayList<String>(failureIndices.size());
                for (Index idx : failureIndices) {
                    concreteIndexNames.add(idx.getName());
                }
                return concreteIndexNames;
            }
            List indices = this.indexAbstraction.getIndices();
            ArrayList<String> concreteIndexNames = new ArrayList<String>(indices.size());
            for (Index idx : indices) {
                concreteIndexNames.add(idx.getName());
            }
            return concreteIndexNames;
        }

        public boolean canHaveBackingIndices() {
            return this.indexAbstraction != null && this.indexAbstraction.getType() != IndexAbstraction.Type.CONCRETE_INDEX;
        }

        public String nameWithSelector() {
            String combined = IndexNameExpressionResolver.combineSelector((String)this.name, (IndexComponentSelector)this.selector);
            assert (IndexComponentSelector.FAILURES.equals((Object)this.selector) || this.name.equals(combined)) : "Only failures selectors should result in explicit selectors suffix";
            return combined;
        }
    }

    private static class DocumentLevelPermissions {
        public static final DocumentLevelPermissions ALLOW_ALL = new DocumentLevelPermissions();
        private Set<BytesReference> queries = null;
        private boolean allowAll = false;

        private DocumentLevelPermissions() {
        }

        private void addAll(Set<BytesReference> query) {
            if (!this.allowAll) {
                if (this.queries == null) {
                    this.queries = Sets.newHashSetWithExpectedSize((int)query.size());
                }
                this.queries.addAll(query);
            }
        }

        private boolean isAllowAll() {
            return this.allowAll;
        }

        static {
            DocumentLevelPermissions.ALLOW_ALL.allowAll = true;
        }
    }

    public static class Builder {
        RestrictedIndices restrictedIndices;
        List<Group> groups = new ArrayList<Group>();

        public Builder(RestrictedIndices restrictedIndices) {
            this.restrictedIndices = restrictedIndices;
        }

        public Builder addGroup(IndexPrivilege privilege, FieldPermissions fieldPermissions, @Nullable Set<BytesReference> query, boolean allowRestrictedIndices, String ... indices) {
            this.groups.add(new Group(privilege, fieldPermissions, query, allowRestrictedIndices, this.restrictedIndices, indices));
            return this;
        }

        public IndicesPermission build() {
            return new IndicesPermission(this.restrictedIndices, this.groups.toArray(Group.EMPTY_ARRAY));
        }
    }
}

