/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.voyageai.embeddings;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.voyageai.VoyageAIService;

public class VoyageAIEmbeddingsTaskSettings
implements TaskSettings {
    public static final String NAME = "voyageai_embeddings_task_settings";
    public static final VoyageAIEmbeddingsTaskSettings EMPTY_SETTINGS = new VoyageAIEmbeddingsTaskSettings(null, null);
    static final String INPUT_TYPE = "input_type";
    private final InputType inputType;
    private final Boolean truncation;

    public static VoyageAIEmbeddingsTaskSettings fromMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return EMPTY_SETTINGS;
        }
        ValidationException validationException = new ValidationException();
        InputType inputType = ServiceUtils.extractOptionalEnum(map, INPUT_TYPE, "task_settings", InputType::fromString, VoyageAIService.VALID_INPUT_TYPE_VALUES, validationException);
        Boolean truncation = ServiceUtils.extractOptionalBoolean(map, "truncation", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new VoyageAIEmbeddingsTaskSettings(inputType, truncation);
    }

    public static VoyageAIEmbeddingsTaskSettings of(VoyageAIEmbeddingsTaskSettings originalSettings, VoyageAIEmbeddingsTaskSettings requestTaskSettings) {
        InputType inputTypeToUse = VoyageAIEmbeddingsTaskSettings.getValidInputType(originalSettings, requestTaskSettings);
        Boolean truncationToUse = VoyageAIEmbeddingsTaskSettings.getValidTruncation(originalSettings, requestTaskSettings);
        return new VoyageAIEmbeddingsTaskSettings(inputTypeToUse, truncationToUse);
    }

    private static InputType getValidInputType(VoyageAIEmbeddingsTaskSettings originalSettings, VoyageAIEmbeddingsTaskSettings requestTaskSettings) {
        InputType inputTypeToUse = originalSettings.inputType;
        if (requestTaskSettings.inputType != null) {
            inputTypeToUse = requestTaskSettings.inputType;
        }
        return inputTypeToUse;
    }

    private static Boolean getValidTruncation(VoyageAIEmbeddingsTaskSettings originalSettings, VoyageAIEmbeddingsTaskSettings requestTaskSettings) {
        return requestTaskSettings.getTruncation() == null ? originalSettings.truncation : requestTaskSettings.getTruncation();
    }

    public VoyageAIEmbeddingsTaskSettings(StreamInput in) throws IOException {
        this((InputType)in.readOptionalEnum(InputType.class), in.readOptionalBoolean());
    }

    public VoyageAIEmbeddingsTaskSettings(@Nullable InputType inputType, @Nullable Boolean truncation) {
        VoyageAIEmbeddingsTaskSettings.validateInputType(inputType);
        this.inputType = inputType;
        this.truncation = truncation;
    }

    private static void validateInputType(InputType inputType) {
        if (inputType == null) {
            return;
        }
        assert (VoyageAIService.VALID_INPUT_TYPE_VALUES.contains(inputType)) : InputType.invalidInputTypeMessage((InputType)inputType);
    }

    public boolean isEmpty() {
        return this.inputType == null && this.truncation == null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.inputType != null) {
            builder.field(INPUT_TYPE, (Enum)this.inputType);
        }
        if (this.truncation != null) {
            builder.field("truncation", this.truncation);
        }
        builder.endObject();
        return builder;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public Boolean getTruncation() {
        return this.truncation;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.VOYAGE_AI_INTEGRATION_ADDED_BACKPORT_8_X;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalEnum((Enum)this.inputType);
        out.writeOptionalBoolean(this.truncation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VoyageAIEmbeddingsTaskSettings that = (VoyageAIEmbeddingsTaskSettings)o;
        return Objects.equals(this.inputType, that.inputType) && Objects.equals(this.truncation, that.truncation);
    }

    public int hashCode() {
        return Objects.hash(this.inputType, this.truncation);
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        VoyageAIEmbeddingsTaskSettings updatedSettings = VoyageAIEmbeddingsTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        return VoyageAIEmbeddingsTaskSettings.of(this, updatedSettings);
    }
}

