/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.sagemaker.schema.elastic;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.action.InferenceAction;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.SageMakerStoredTaskSchema;

record SageMakerElasticTaskSettings(@Nullable Map<String, Object> passthroughSettings) implements SageMakerStoredTaskSchema
{
    static final String NAME = "sagemaker_elastic_task_settings";

    SageMakerElasticTaskSettings(StreamInput in) throws IOException {
        this(in.readGenericMap());
    }

    static SageMakerElasticTaskSettings empty() {
        return new SageMakerElasticTaskSettings(Map.of());
    }

    public boolean isEmpty() {
        return this.passthroughSettings == null || this.passthroughSettings.isEmpty();
    }

    @Override
    public SageMakerStoredTaskSchema updatedTaskSettings(Map<String, Object> newSettings) {
        ValidationException validationException = new ValidationException();
        validationException.addValidationError(InferenceAction.Request.TASK_SETTINGS.getPreferredName() + " is only supported during the inference request and cannot be stored in the inference endpoint.");
        throw validationException;
    }

    @Override
    public SageMakerStoredTaskSchema override(Map<String, Object> newSettings) {
        return new SageMakerElasticTaskSettings(newSettings);
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_SAGEMAKER_ELASTIC_8_19;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeGenericMap(this.passthroughSettings);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.isEmpty() ? builder : builder.mapContents(this.passthroughSettings);
    }
}

