/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.sagemaker.schema;

import java.util.EnumSet;
import java.util.Map;
import java.util.stream.Stream;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.services.sagemaker.SageMakerInferenceRequest;
import org.elasticsearch.xpack.inference.services.sagemaker.model.SageMakerModel;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.SageMakerStoredServiceSchema;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.SageMakerStoredTaskSchema;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointResponse;

public interface SageMakerSchemaPayload {
    public String api();

    public EnumSet<TaskType> supportedTasks();

    default public SageMakerStoredServiceSchema apiServiceSettings(Map<String, Object> serviceSettings, ValidationException validationException) {
        return SageMakerStoredServiceSchema.NO_OP;
    }

    default public SageMakerStoredTaskSchema apiTaskSettings(Map<String, Object> taskSettings, ValidationException validationException) {
        return SageMakerStoredTaskSchema.NO_OP;
    }

    default public Exception createUnsupportedSchemaException(SageMakerModel model) {
        return new IllegalArgumentException(Strings.format((String)"Unsupported SageMaker settings for api [%s] and task type [%s]: [%s] and [%s]", (Object[])new Object[]{model.api(), model.getTaskType(), model.apiServiceSettings().getWriteableName(), model.apiTaskSettings().getWriteableName()}));
    }

    default public Stream<NamedWriteableRegistry.Entry> namedWriteables() {
        return Stream.of(new NamedWriteableRegistry.Entry[0]);
    }

    public String accept(SageMakerModel var1);

    public String contentType(SageMakerModel var1);

    public SdkBytes requestBytes(SageMakerModel var1, SageMakerInferenceRequest var2) throws Exception;

    public InferenceServiceResults responseBody(SageMakerModel var1, InvokeEndpointResponse var2) throws Exception;
}

