/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.sagemaker.model;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.SageMakerSchema;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.SageMakerSchemas;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.SageMakerStoredServiceSchema;

record SageMakerServiceSettings(String endpointName, String region, String api, @Nullable String targetModel, @Nullable String targetContainerHostname, @Nullable String inferenceComponentName, @Nullable Integer batchSize, SageMakerStoredServiceSchema apiServiceSettings) implements ServiceSettings
{
    static final String NAME = "sage_maker_service_settings";
    private static final String API = "api";
    private static final String ENDPOINT_NAME = "endpoint_name";
    private static final String REGION = "region";
    private static final String TARGET_MODEL = "target_model";
    private static final String TARGET_CONTAINER_HOSTNAME = "target_container_hostname";
    private static final String INFERENCE_COMPONENT_NAME = "inference_component_name";
    private static final String BATCH_SIZE = "batch_size";

    SageMakerServiceSettings {
        Objects.requireNonNull(endpointName);
        Objects.requireNonNull(region);
        Objects.requireNonNull(api);
        Objects.requireNonNull(apiServiceSettings);
    }

    SageMakerServiceSettings(StreamInput in) throws IOException {
        this(in.readString(), in.readString(), in.readString(), in.readOptionalString(), in.readOptionalString(), in.readOptionalString(), in.readOptionalInt(), (SageMakerStoredServiceSchema)in.readNamedWriteable(SageMakerStoredServiceSchema.class));
    }

    public String modelId() {
        return this.apiServiceSettings.modelId();
    }

    public SimilarityMeasure similarity() {
        return this.apiServiceSettings.similarity();
    }

    public Integer dimensions() {
        return this.apiServiceSettings.dimensions();
    }

    public Boolean dimensionsSetByUser() {
        return this.apiServiceSettings.dimensionsSetByUser();
    }

    public DenseVectorFieldMapper.ElementType elementType() {
        return this.apiServiceSettings.elementType();
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_SAGEMAKER_8_19;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.endpointName());
        out.writeString(this.region());
        out.writeString(this.api());
        out.writeOptionalString(this.targetModel());
        out.writeOptionalString(this.targetContainerHostname());
        out.writeOptionalString(this.inferenceComponentName());
        out.writeOptionalInt(this.batchSize());
        out.writeNamedWriteable((NamedWriteable)this.apiServiceSettings);
    }

    public ToXContentObject getFilteredXContentObject() {
        return this;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ENDPOINT_NAME, this.endpointName());
        builder.field(REGION, this.region());
        builder.field(API, this.api());
        SageMakerServiceSettings.optionalField(TARGET_MODEL, this.targetModel(), builder);
        SageMakerServiceSettings.optionalField(TARGET_CONTAINER_HOSTNAME, this.targetContainerHostname(), builder);
        SageMakerServiceSettings.optionalField(INFERENCE_COMPONENT_NAME, this.inferenceComponentName(), builder);
        SageMakerServiceSettings.optionalField(BATCH_SIZE, this.batchSize(), builder);
        this.apiServiceSettings.toXContent(builder, params);
        return builder.endObject();
    }

    private static <T> void optionalField(String name, T value, XContentBuilder builder) throws IOException {
        if (value != null) {
            builder.field(name, value);
        }
    }

    static SageMakerServiceSettings fromMap(SageMakerSchemas schemas, TaskType taskType, Map<String, Object> serviceSettingsMap) {
        ValidationException validationException = new ValidationException();
        String endpointName = ServiceUtils.extractRequiredString(serviceSettingsMap, ENDPOINT_NAME, "service_settings", validationException);
        String region = ServiceUtils.extractRequiredString(serviceSettingsMap, REGION, "service_settings", validationException);
        String api = ServiceUtils.extractRequiredString(serviceSettingsMap, API, "service_settings", validationException);
        String targetModel = ServiceUtils.extractOptionalString(serviceSettingsMap, TARGET_MODEL, "service_settings", validationException);
        String targetContainerHostname = ServiceUtils.extractOptionalString(serviceSettingsMap, TARGET_CONTAINER_HOSTNAME, "service_settings", validationException);
        String inferenceComponentName = ServiceUtils.extractOptionalString(serviceSettingsMap, INFERENCE_COMPONENT_NAME, "service_settings", validationException);
        Integer batchSize = ServiceUtils.extractOptionalPositiveInteger(serviceSettingsMap, BATCH_SIZE, "service_settings", validationException);
        validationException.throwIfValidationErrorsExist();
        SageMakerSchema schema = schemas.schemaFor(taskType, api);
        SageMakerStoredServiceSchema apiServiceSettings = schema.apiServiceSettings(serviceSettingsMap, validationException);
        validationException.throwIfValidationErrorsExist();
        return new SageMakerServiceSettings(endpointName, region, api, targetModel, targetContainerHostname, inferenceComponentName, batchSize, apiServiceSettings);
    }

    static Stream<Map.Entry<String, SettingsConfiguration>> configuration(EnumSet<TaskType> supportedTaskTypes) {
        return Stream.of(Map.entry(API, new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("The API format that your SageMaker Endpoint expects.").setLabel("API").setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build()), Map.entry(ENDPOINT_NAME, new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("The name specified when creating the SageMaker Endpoint.").setLabel("Endpoint Name").setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build()), Map.entry(REGION, new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("The AWS region that your model or ARN is deployed in.").setLabel("Region").setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build()), Map.entry(TARGET_MODEL, new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("The model to request when calling a SageMaker multi-model Endpoint.").setLabel("Target Model").setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build()), Map.entry(TARGET_CONTAINER_HOSTNAME, new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("The hostname of the container when calling a SageMaker multi-container Endpoint.").setLabel("Target Container Hostname").setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build()), Map.entry(BATCH_SIZE, new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("The maximum size a single chunk of input can be when chunking input for semantic text.").setLabel("Batch Size").setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.INTEGER).build()));
    }
}

