/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.mistral;

import java.util.Locale;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.inference.results.UnifiedChatCompletionException;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorResponse;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.mistral.response.MistralErrorResponse;
import org.elasticsearch.xpack.inference.services.openai.OpenAiUnifiedChatCompletionResponseHandler;

public class MistralUnifiedChatCompletionResponseHandler
extends OpenAiUnifiedChatCompletionResponseHandler {
    private static final String MISTRAL_ERROR = "mistral_error";

    public MistralUnifiedChatCompletionResponseHandler(String requestType, ResponseParser parseFunction) {
        super(requestType, parseFunction, MistralErrorResponse::fromResponse);
    }

    @Override
    protected Exception buildError(String message, Request request, HttpResult result, ErrorResponse errorResponse) {
        assert (request.isStreaming()) : "Only streaming requests support this format";
        int responseStatusCode = result.response().getStatusLine().getStatusCode();
        if (request.isStreaming()) {
            String errorMessage = this.errorMessage(message, request, result, errorResponse, responseStatusCode);
            RestStatus restStatus = MistralUnifiedChatCompletionResponseHandler.toRestStatus(responseStatusCode);
            return errorResponse instanceof MistralErrorResponse ? new UnifiedChatCompletionException(restStatus, errorMessage, MISTRAL_ERROR, restStatus.name().toLowerCase(Locale.ROOT)) : new UnifiedChatCompletionException(restStatus, errorMessage, MistralUnifiedChatCompletionResponseHandler.createErrorType(errorResponse), restStatus.name().toLowerCase(Locale.ROOT));
        }
        return super.buildError(message, request, result, errorResponse);
    }
}

