/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.huggingface.rerank;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public class HuggingFaceRerankTaskSettings
implements TaskSettings {
    public static final String NAME = "hugging_face_rerank_task_settings";
    public static final String RETURN_DOCUMENTS = "return_documents";
    public static final String TOP_N_DOCS_ONLY = "top_n";
    static final HuggingFaceRerankTaskSettings EMPTY_SETTINGS = new HuggingFaceRerankTaskSettings(null, null);
    private final Integer topNDocumentsOnly;
    private final Boolean returnDocuments;

    public static HuggingFaceRerankTaskSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        if (map == null || map.isEmpty()) {
            return EMPTY_SETTINGS;
        }
        Boolean returnDocuments = ServiceUtils.extractOptionalBoolean(map, RETURN_DOCUMENTS, validationException);
        Integer topNDocumentsOnly = ServiceUtils.extractOptionalPositiveInteger(map, TOP_N_DOCS_ONLY, "task_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return HuggingFaceRerankTaskSettings.of(topNDocumentsOnly, returnDocuments);
    }

    public static HuggingFaceRerankTaskSettings of(HuggingFaceRerankTaskSettings originalSettings, HuggingFaceRerankTaskSettings requestTaskSettings) {
        return new HuggingFaceRerankTaskSettings(requestTaskSettings.getTopNDocumentsOnly() != null ? requestTaskSettings.getTopNDocumentsOnly() : originalSettings.getTopNDocumentsOnly(), requestTaskSettings.getReturnDocuments() != null ? requestTaskSettings.getReturnDocuments() : originalSettings.getReturnDocuments());
    }

    public static HuggingFaceRerankTaskSettings of(Integer topNDocumentsOnly, Boolean returnDocuments) {
        return new HuggingFaceRerankTaskSettings(topNDocumentsOnly, returnDocuments);
    }

    public HuggingFaceRerankTaskSettings(StreamInput in) throws IOException {
        this(in.readOptionalVInt(), in.readOptionalBoolean());
    }

    public HuggingFaceRerankTaskSettings(@Nullable Integer topNDocumentsOnly, @Nullable Boolean doReturnDocuments) {
        this.topNDocumentsOnly = topNDocumentsOnly;
        this.returnDocuments = doReturnDocuments;
    }

    public boolean isEmpty() {
        return this.topNDocumentsOnly == null && this.returnDocuments == null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.topNDocumentsOnly != null) {
            builder.field(TOP_N_DOCS_ONLY, this.topNDocumentsOnly);
        }
        if (this.returnDocuments != null) {
            builder.field(RETURN_DOCUMENTS, this.returnDocuments);
        }
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_HUGGING_FACE_RERANK_ADDED_8_19;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalVInt(this.topNDocumentsOnly);
        out.writeOptionalBoolean(this.returnDocuments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HuggingFaceRerankTaskSettings that = (HuggingFaceRerankTaskSettings)o;
        return Objects.equals(this.returnDocuments, that.returnDocuments) && Objects.equals(this.topNDocumentsOnly, that.topNDocumentsOnly);
    }

    public int hashCode() {
        return Objects.hash(this.returnDocuments, this.topNDocumentsOnly);
    }

    public Integer getTopNDocumentsOnly() {
        return this.topNDocumentsOnly;
    }

    public Boolean getReturnDocuments() {
        return this.returnDocuments;
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        HuggingFaceRerankTaskSettings updatedSettings = HuggingFaceRerankTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        return HuggingFaceRerankTaskSettings.of(this, updatedSettings);
    }
}

