/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.custom;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public class CustomSecretSettings
implements SecretSettings {
    public static final String NAME = "custom_secret_settings";
    public static final String SECRET_PARAMETERS = "secret_parameters";
    private final Map<String, SecureString> secretParameters;

    public static CustomSecretSettings fromMap(@Nullable Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        ValidationException validationException = new ValidationException();
        Map<String, Object> requestSecretParamsMap = ServiceUtils.extractOptionalMap(map, SECRET_PARAMETERS, NAME, validationException);
        ServiceUtils.removeNullValues(requestSecretParamsMap);
        Map<String, SecureString> secureStringMap = ServiceUtils.convertMapStringsToSecureString(requestSecretParamsMap, SECRET_PARAMETERS, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new CustomSecretSettings(secureStringMap);
    }

    public SecretSettings newSecretSettings(Map<String, Object> newSecrets) {
        return CustomSecretSettings.fromMap(new HashMap<String, Object>(newSecrets));
    }

    public CustomSecretSettings(@Nullable Map<String, SecureString> secretParameters) {
        this.secretParameters = Objects.requireNonNullElse(secretParameters, Map.of());
    }

    public CustomSecretSettings(StreamInput in) throws IOException {
        this.secretParameters = in.readImmutableMap(StreamInput::readSecureString);
    }

    public Map<String, SecureString> getSecretParameters() {
        return this.secretParameters;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (!this.secretParameters.isEmpty()) {
            builder.startObject(SECRET_PARAMETERS);
            for (Map.Entry<String, SecureString> entry : this.secretParameters.entrySet()) {
                builder.field(entry.getKey(), entry.getValue().toString());
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.INFERENCE_CUSTOM_SERVICE_ADDED_8_19;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.secretParameters, StreamOutput::writeSecureString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomSecretSettings that = (CustomSecretSettings)o;
        return Objects.equals(this.secretParameters, that.secretParameters);
    }

    public int hashCode() {
        return Objects.hash(this.secretParameters);
    }
}

