/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.cohere.rerank;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.cohere.CohereRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.cohere.CohereServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class CohereRerankServiceSettings
extends FilteredXContentObject
implements ServiceSettings,
CohereRateLimitServiceSettings {
    public static final String NAME = "cohere_rerank_service_settings";
    private final URI uri;
    private final String modelId;
    private final RateLimitSettings rateLimitSettings;
    private final CohereServiceSettings.CohereApiVersion apiVersion;

    public static CohereRerankServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        String url = ServiceUtils.extractOptionalString(map, "url", "service_settings", validationException);
        ServiceUtils.extractSimilarity(map, "service_settings", validationException);
        ServiceUtils.removeAsType(map, "dimensions", Integer.class);
        ServiceUtils.removeAsType(map, "max_input_tokens", Integer.class);
        URI uri = ServiceUtils.convertToUri(url, "url", "service_settings", validationException);
        String modelId = ServiceUtils.extractOptionalString(map, "model_id", "service_settings", validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, CohereServiceSettings.DEFAULT_RATE_LIMIT_SETTINGS, validationException, "cohere", context);
        CohereServiceSettings.CohereApiVersion apiVersion = CohereServiceSettings.apiVersionFromMap(map, context, validationException);
        if (apiVersion == CohereServiceSettings.CohereApiVersion.V2 && modelId == null) {
            validationException.addValidationError("The [service_settings.model_id] field is required for the Cohere V2 API.");
        }
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new CohereRerankServiceSettings(uri, modelId, rateLimitSettings, apiVersion);
    }

    public CohereRerankServiceSettings(@Nullable URI uri, @Nullable String modelId, @Nullable RateLimitSettings rateLimitSettings, CohereServiceSettings.CohereApiVersion apiVersion) {
        this.uri = uri;
        this.modelId = modelId;
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, CohereServiceSettings.DEFAULT_RATE_LIMIT_SETTINGS);
        this.apiVersion = apiVersion;
    }

    public CohereRerankServiceSettings(@Nullable String url, @Nullable String modelId, @Nullable RateLimitSettings rateLimitSettings, CohereServiceSettings.CohereApiVersion apiVersion) {
        this(ServiceUtils.createOptionalUri(url), modelId, rateLimitSettings, apiVersion);
    }

    public CohereRerankServiceSettings(StreamInput in) throws IOException {
        this.uri = ServiceUtils.createOptionalUri(in.readOptionalString());
        if (in.getTransportVersion().before((VersionId)TransportVersions.V_8_16_0)) {
            in.readOptionalEnum(SimilarityMeasure.class);
            in.readOptionalVInt();
            in.readOptionalVInt();
        }
        this.modelId = in.readOptionalString();
        this.rateLimitSettings = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_0) ? new RateLimitSettings(in) : CohereServiceSettings.DEFAULT_RATE_LIMIT_SETTINGS;
        this.apiVersion = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ML_INFERENCE_COHERE_API_VERSION_8_19) ? (CohereServiceSettings.CohereApiVersion)in.readEnum(CohereServiceSettings.CohereApiVersion.class) : CohereServiceSettings.CohereApiVersion.V1;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    public String modelId() {
        return this.modelId;
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    @Override
    public CohereServiceSettings.CohereApiVersion apiVersion() {
        return this.apiVersion;
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragmentOfExposedFields(builder, params);
        builder.field("api_version", (Enum)this.apiVersion);
        builder.endObject();
        return builder;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.uri != null) {
            builder.field("url", this.uri.toString());
        }
        if (this.modelId != null) {
            builder.field("model_id", this.modelId);
        }
        this.rateLimitSettings.toXContent(builder, params);
        return builder;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_14_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        String uriToWrite = this.uri != null ? this.uri.toString() : null;
        out.writeOptionalString(uriToWrite);
        if (out.getTransportVersion().before((VersionId)TransportVersions.V_8_16_0)) {
            out.writeOptionalEnum(null);
            out.writeOptionalVInt(null);
            out.writeOptionalVInt(null);
        }
        out.writeOptionalString(this.modelId);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_0)) {
            this.rateLimitSettings.writeTo(out);
        }
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ML_INFERENCE_COHERE_API_VERSION_8_19)) {
            out.writeEnum((Enum)this.apiVersion);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CohereRerankServiceSettings that = (CohereRerankServiceSettings)object;
        return Objects.equals(this.uri, that.uri) && Objects.equals(this.modelId, that.modelId) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings) && this.apiVersion == that.apiVersion;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uri, this.modelId, this.rateLimitSettings, this.apiVersion});
    }
}

