/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.cohere;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.StreamingChatCompletionResults;
import org.elasticsearch.xpack.inference.common.DelegatingProcessor;

class CohereStreamingProcessor
extends DelegatingProcessor<Deque<String>, StreamingChatCompletionResults.Results> {
    private static final Logger log = LogManager.getLogger(CohereStreamingProcessor.class);

    CohereStreamingProcessor() {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void next(Deque<String> item) throws Exception {
        if (item.isEmpty()) {
            this.upstream().request(1L);
            return;
        }
        results = new ArrayDeque<E>(item.size());
lbl5:
        // 6 sources

        for (String json : item) {
            try {
                jsonParser = CohereStreamingProcessor.jsonParser(json);
                try {
                    responseMap = jsonParser.map();
                    var8_12 = eventType = (String)responseMap.get("event_type");
                    var9_13 = -1;
                    switch (var8_12.hashCode()) {
                        case 1547878840: {
                            if (!var8_12.equals("text-generation")) break;
                            var9_13 = 0;
                            break;
                        }
                        case -1195930354: {
                            if (!var8_12.equals("stream-end")) break;
                            var9_13 = 1;
                            break;
                        }
                        case 1775273941: {
                            if (!var8_12.equals("stream-start")) break;
                            var9_13 = 2;
                            break;
                        }
                        case 128784932: {
                            if (!var8_12.equals("search-queries-generation")) break;
                            var9_13 = 3;
                            break;
                        }
                        case 11427025: {
                            if (!var8_12.equals("search-results")) break;
                            var9_13 = 4;
                            break;
                        }
                        case -2132016194: {
                            if (!var8_12.equals("citation-generation")) break;
                            var9_13 = 5;
                            break;
                        }
                        case 1348484005: {
                            if (!var8_12.equals("tool-calls-generation")) break;
                            var9_13 = 6;
                            break;
                        }
                        case -1360761920: {
                            if (!var8_12.equals("tool-calls-chunk")) break;
                            var9_13 = 7;
                        }
                    }
                    switch (var9_13) {
                        case 0: {
                            this.parseText(responseMap).ifPresent((Consumer<StreamingChatCompletionResults.Result>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, offer(E ), (Lorg/elasticsearch/xpack/core/inference/results/StreamingChatCompletionResults$Result;)V)(results));
                            ** break;
                        }
                        case 1: {
                            this.validateResponse(responseMap);
                            ** break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            CohereStreamingProcessor.log.debug("Skipping event type [{}] for line [{}].", (Object)eventType, item);
                            ** break;
                        }
                        default: {
                            throw new IOException("Unknown eventType found: " + eventType);
                        }
                    }
                }
                finally {
                    if (jsonParser == null) continue;
                    jsonParser.close();
                }
            }
            catch (ElasticsearchStatusException e) {
                throw e;
            }
            catch (Exception e) {
                CohereStreamingProcessor.log.warn("Failed to parse json from cohere: {}", (Object)json);
                throw e;
            }
        }
        if (results.isEmpty()) {
            this.upstream().request(1L);
        } else {
            this.downstream().onNext(new StreamingChatCompletionResults.Results(results));
        }
    }

    private static XContentParser jsonParser(String line) throws IOException {
        return XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, line);
    }

    private Optional<StreamingChatCompletionResults.Result> parseText(Map<String, Object> responseMap) throws IOException {
        String text = (String)responseMap.get("text");
        if (text != null) {
            return Optional.of(new StreamingChatCompletionResults.Result(text));
        }
        throw new IOException("Null text found in text-generation cohere event");
    }

    private void validateResponse(Map<String, Object> responseMap) {
        String finishReason;
        switch (finishReason = (String)responseMap.get("finish_reason")) {
            case "ERROR": 
            case "ERROR_TOXIC": {
                throw new ElasticsearchStatusException("Cohere stopped the stream due to an error: {}", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{this.parseErrorMessage(responseMap)});
            }
            case "ERROR_LIMIT": {
                throw new ElasticsearchStatusException("Cohere stopped the stream due to an error: {}", RestStatus.TOO_MANY_REQUESTS, new Object[]{this.parseErrorMessage(responseMap)});
            }
        }
    }

    private String parseErrorMessage(Map<String, Object> responseMap) {
        Map innerResponseMap = (Map)responseMap.get("response");
        return (String)innerResponseMap.get("text");
    }
}

