/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.rank.random;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.rank.RankBuilder;
import org.elasticsearch.search.retriever.RetrieverBuilder;
import org.elasticsearch.search.retriever.RetrieverParserContext;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.inference.rank.random.RandomRankBuilder;

public class RandomRankRetrieverBuilder
extends RetrieverBuilder {
    public static final NodeFeature RANDOM_RERANKER_RETRIEVER_SUPPORTED = new NodeFeature("random_reranker_retriever_supported", true);
    public static final ParseField RETRIEVER_FIELD = new ParseField("retriever", new String[0]);
    public static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    public static final ParseField RANK_WINDOW_SIZE_FIELD = new ParseField("rank_window_size", new String[0]);
    public static final ParseField SEED_FIELD = new ParseField("seed", new String[0]);
    public static final ConstructingObjectParser<RandomRankRetrieverBuilder, RetrieverParserContext> PARSER = new ConstructingObjectParser("random_reranker", args -> {
        RetrieverBuilder retrieverBuilder = (RetrieverBuilder)args[0];
        String field = (String)args[1];
        int rankWindowSize = args[2] == null ? 10 : (Integer)args[2];
        Integer seed = (Integer)args[3];
        return new RandomRankRetrieverBuilder(retrieverBuilder, field, rankWindowSize, seed);
    });
    private final RetrieverBuilder retrieverBuilder;
    private final String field;
    private final int rankWindowSize;
    private final Integer seed;

    public static RandomRankRetrieverBuilder fromXContent(XContentParser parser, RetrieverParserContext context) throws IOException {
        if (!context.clusterSupportsFeature(RANDOM_RERANKER_RETRIEVER_SUPPORTED)) {
            throw new ParsingException(parser.getTokenLocation(), "unknown retriever [random_reranker]", new Object[0]);
        }
        return (RandomRankRetrieverBuilder)((Object)PARSER.apply(parser, (Object)context));
    }

    private static RetrieverBuilder parseRetrieverBuilder(XContentParser parser, RetrieverParserContext context) throws IOException {
        assert (parser.currentToken() == XContentParser.Token.START_OBJECT);
        parser.nextToken();
        if (parser.currentToken() == XContentParser.Token.END_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "empty [" + String.valueOf(RETRIEVER_FIELD) + "] object", new Object[0]);
        }
        assert (parser.currentToken() == XContentParser.Token.FIELD_NAME);
        RetrieverBuilder builder = (RetrieverBuilder)parser.namedObject(RetrieverBuilder.class, parser.currentName(), (Object)context);
        parser.nextToken();
        if (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
            throw new ParsingException(parser.getTokenLocation(), "unexpected field [" + parser.currentName() + "]", new Object[0]);
        }
        assert (parser.currentToken() == XContentParser.Token.END_OBJECT);
        return builder;
    }

    public RandomRankRetrieverBuilder(RetrieverBuilder retrieverBuilder, String field, int rankWindowSize, Integer seed) {
        this.retrieverBuilder = retrieverBuilder;
        this.field = field;
        this.rankWindowSize = rankWindowSize;
        this.seed = seed;
    }

    public QueryBuilder topDocsQuery() {
        return this.retrieverBuilder.topDocsQuery();
    }

    public void extractToSearchSourceBuilder(SearchSourceBuilder searchSourceBuilder, boolean compoundUsed) {
        this.retrieverBuilder.extractToSearchSourceBuilder(searchSourceBuilder, compoundUsed);
        if (searchSourceBuilder.rankBuilder() != null) {
            throw new IllegalArgumentException("random rank builder cannot be combined with other rank builders");
        }
        searchSourceBuilder.rankBuilder((RankBuilder)new RandomRankBuilder(this.rankWindowSize, this.field, this.seed));
    }

    public String getName() {
        return "random_reranker";
    }

    public int rankWindowSize() {
        return this.rankWindowSize;
    }

    protected void doToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(RETRIEVER_FIELD.getPreferredName(), (ToXContent)this.retrieverBuilder);
        builder.field(FIELD_FIELD.getPreferredName(), this.field);
        builder.field(RANK_WINDOW_SIZE_FIELD.getPreferredName(), this.rankWindowSize);
        if (this.seed != null) {
            builder.field(SEED_FIELD.getPreferredName(), this.seed);
        }
    }

    protected boolean doEquals(Object other) {
        RandomRankRetrieverBuilder that = (RandomRankRetrieverBuilder)((Object)other);
        return Objects.equals(this.retrieverBuilder, that.retrieverBuilder) && Objects.equals(this.field, that.field) && Objects.equals(this.rankWindowSize, that.rankWindowSize) && Objects.equals(this.seed, that.seed);
    }

    protected int doHashCode() {
        return Objects.hash(this.retrieverBuilder, this.field, this.rankWindowSize, this.seed);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), RandomRankRetrieverBuilder::parseRetrieverBuilder, RETRIEVER_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), FIELD_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), RANK_WINDOW_SIZE_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), SEED_FIELD);
        RetrieverBuilder.declareBaseParserFields((String)"random_reranker", PARSER);
    }
}

