/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ChunkInferenceInput;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;

public class EmbeddingsInput
extends InferenceInputs {
    private final Supplier<List<ChunkInferenceInput>> listSupplier;
    private final InputType inputType;

    public static EmbeddingsInput of(InferenceInputs inferenceInputs) {
        if (!(inferenceInputs instanceof EmbeddingsInput)) {
            throw EmbeddingsInput.createUnsupportedTypeException(inferenceInputs, EmbeddingsInput.class);
        }
        return (EmbeddingsInput)inferenceInputs;
    }

    public EmbeddingsInput(List<ChunkInferenceInput> input, @Nullable InputType inputType) {
        this(input, inputType, false);
    }

    public EmbeddingsInput(Supplier<List<ChunkInferenceInput>> inputSupplier, @Nullable InputType inputType) {
        super(false);
        this.listSupplier = Objects.requireNonNull(inputSupplier);
        this.inputType = inputType;
    }

    public EmbeddingsInput(List<String> input, @Nullable ChunkingSettings chunkingSettings, @Nullable InputType inputType) {
        this(input.stream().map(i -> new ChunkInferenceInput(i, chunkingSettings)).collect(Collectors.toList()), inputType, false);
    }

    public EmbeddingsInput(List<ChunkInferenceInput> input, @Nullable InputType inputType, boolean stream) {
        super(stream);
        Objects.requireNonNull(input);
        this.listSupplier = () -> input;
        this.inputType = inputType;
    }

    public List<ChunkInferenceInput> getInputs() {
        return this.listSupplier.get();
    }

    public static EmbeddingsInput fromStrings(List<String> input, @Nullable InputType inputType) {
        return new EmbeddingsInput(input, null, inputType);
    }

    public List<String> getStringInputs() {
        return this.getInputs().stream().map(ChunkInferenceInput::input).collect(Collectors.toList());
    }

    public InputType getInputType() {
        return this.inputType;
    }

    @Override
    public boolean isSingleInput() {
        return false;
    }
}

