/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.action;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.mapper.StrictDynamicMappingException;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceRegistry;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.action.PutInferenceModelAction;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignmentUtils;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.inference.InferencePlugin;
import org.elasticsearch.xpack.inference.registry.ModelRegistry;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.validation.ModelValidatorBuilder;

public class TransportPutInferenceModelAction
extends TransportMasterNodeAction<PutInferenceModelAction.Request, PutInferenceModelAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportPutInferenceModelAction.class);
    private final XPackLicenseState licenseState;
    private final ModelRegistry modelRegistry;
    private final InferenceServiceRegistry serviceRegistry;
    private final Client client;
    private volatile boolean skipValidationAndStart;

    @Inject
    public TransportPutInferenceModelAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, XPackLicenseState licenseState, ModelRegistry modelRegistry, InferenceServiceRegistry serviceRegistry, Client client, Settings settings) {
        super("cluster:admin/xpack/inference/put", transportService, clusterService, threadPool, actionFilters, PutInferenceModelAction.Request::new, PutInferenceModelAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.licenseState = licenseState;
        this.modelRegistry = modelRegistry;
        this.serviceRegistry = serviceRegistry;
        this.client = client;
        this.skipValidationAndStart = (Boolean)InferencePlugin.SKIP_VALIDATE_AND_START.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(InferencePlugin.SKIP_VALIDATE_AND_START, this::setSkipValidationAndStart);
    }

    protected void masterOperation(Task task, PutInferenceModelAction.Request request, ClusterState state, ActionListener<PutInferenceModelAction.Response> listener) throws Exception {
        Optional service;
        if (!InferencePlugin.INFERENCE_API_FEATURE.check(this.licenseState)) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"inference"));
            return;
        }
        if (this.modelRegistry.containsDefaultConfigId(request.getInferenceEntityId())) {
            listener.onFailure((Exception)new ElasticsearchStatusException("[{}] is a reserved inference ID. Cannot create a new inference endpoint with a reserved ID.", RestStatus.BAD_REQUEST, new Object[]{request.getInferenceEntityId()}));
            return;
        }
        Map<String, Object> requestAsMap = this.requestToMap(request);
        TaskType resolvedTaskType = ServiceUtils.resolveTaskType(request.getTaskType(), (String)requestAsMap.remove(TaskType.NAME));
        String serviceName = (String)requestAsMap.remove("service");
        if (serviceName == null) {
            listener.onFailure((Exception)new ElasticsearchStatusException("Inference endpoint configuration is missing the [service] setting", RestStatus.BAD_REQUEST, new Object[0]));
            return;
        }
        if (List.of("elser", "elasticsearch").contains(serviceName)) {
            requestAsMap.put("service", serviceName);
        }
        if ((service = this.serviceRegistry.getService(serviceName)).isEmpty()) {
            listener.onFailure((Exception)new ElasticsearchStatusException("Unknown service [{}]", RestStatus.BAD_REQUEST, new Object[]{serviceName}));
            return;
        }
        if (((InferenceService)service.get()).getMinimalSupportedVersion().after((VersionId)state.getMinTransportVersion())) {
            logger.warn(Strings.format((String)"Service [%s] requires version [%s] but minimum cluster version is [%s]", (Object[])new Object[]{serviceName, ((InferenceService)service.get()).getMinimalSupportedVersion(), state.getMinTransportVersion()}));
            listener.onFailure((Exception)new ElasticsearchStatusException(Strings.format((String)"All nodes in the cluster are not aware of the service [%s].Wait for the cluster to finish upgrading and try again.", (Object[])new Object[]{serviceName}), RestStatus.BAD_REQUEST, new Object[0]));
            return;
        }
        List assignments = TrainedModelAssignmentUtils.modelAssignments((String)request.getInferenceEntityId(), (ClusterState)this.clusterService.state());
        if (!(assignments == null || assignments.isEmpty())) {
            listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"Model IDs must be unique. Requested model ID [{}] matches existing model IDs but must not.", (Object[])new Object[]{request.getInferenceEntityId()}));
            return;
        }
        this.parseAndStoreModel((InferenceService)service.get(), request.getInferenceEntityId(), resolvedTaskType, requestAsMap, request.getTimeout(), listener);
    }

    private void parseAndStoreModel(InferenceService service, String inferenceEntityId, TaskType taskType, Map<String, Object> config, TimeValue timeout, ActionListener<PutInferenceModelAction.Response> listener) {
        ActionListener storeModelListener = listener.delegateFailureAndWrap((delegate, verifiedModel) -> this.modelRegistry.storeModel((Model)verifiedModel, (ActionListener<Boolean>)ActionListener.wrap(r -> this.startInferenceEndpoint(service, timeout, (Model)verifiedModel, (ActionListener<PutInferenceModelAction.Response>)delegate), e -> {
            if (e.getCause() instanceof StrictDynamicMappingException && e.getCause().getMessage().contains("chunking_settings")) {
                delegate.onFailure((Exception)new ElasticsearchStatusException("One or more nodes in your cluster does not support chunking_settings. Please update all nodes in your cluster to the latest version to use chunking_settings.", RestStatus.BAD_REQUEST, new Object[0]));
            } else {
                delegate.onFailure(e);
            }
        }), timeout));
        ActionListener parsedModelListener = listener.delegateFailureAndWrap((delegate, model) -> {
            if (this.skipValidationAndStart) {
                storeModelListener.onResponse(model);
            } else {
                ModelValidatorBuilder.buildModelValidator(model.getTaskType(), service).validate(service, (Model)model, timeout, (ActionListener<Model>)storeModelListener);
            }
        });
        service.parseRequestConfig(inferenceEntityId, taskType, config, parsedModelListener);
    }

    private void startInferenceEndpoint(InferenceService service, TimeValue timeout, Model model, ActionListener<PutInferenceModelAction.Response> listener) {
        if (this.skipValidationAndStart) {
            listener.onResponse((Object)new PutInferenceModelAction.Response(model.getConfigurations()));
        } else {
            service.start(model, timeout, listener.map(started -> new PutInferenceModelAction.Response(model.getConfigurations())));
        }
    }

    private Map<String, Object> requestToMap(PutInferenceModelAction.Request request) throws IOException {
        try (XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)request.getContent(), (XContentType)request.getContentType());){
            Map map = parser.map();
            return map;
        }
    }

    private void setSkipValidationAndStart(boolean skipValidationAndStart) {
        this.skipValidationAndStart = skipValidationAndStart;
    }

    protected ClusterBlockException checkBlock(PutInferenceModelAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

