/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.io.IOException;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.admin.cluster.stats.CCSUsage;
import org.elasticsearch.action.admin.cluster.stats.CCSUsageTelemetry;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.compute.data.BlockFactoryProvider;
import org.elasticsearch.compute.operator.exchange.ExchangeService;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.indices.IndicesExpressionGrouper;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskAwareRequest;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.usage.UsageService;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.action.ColumnInfoImpl;
import org.elasticsearch.xpack.esql.action.EsqlExecutionInfo;
import org.elasticsearch.xpack.esql.action.EsqlQueryAction;
import org.elasticsearch.xpack.esql.action.EsqlQueryRequest;
import org.elasticsearch.xpack.esql.action.EsqlQueryResponse;
import org.elasticsearch.xpack.esql.action.EsqlQueryTask;
import org.elasticsearch.xpack.esql.core.async.AsyncTaskManagementService;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.enrich.AbstractLookupService;
import org.elasticsearch.xpack.esql.enrich.EnrichLookupService;
import org.elasticsearch.xpack.esql.enrich.EnrichPolicyResolver;
import org.elasticsearch.xpack.esql.enrich.LookupFromIndexService;
import org.elasticsearch.xpack.esql.execution.PlanExecutor;
import org.elasticsearch.xpack.esql.inference.InferenceRunner;
import org.elasticsearch.xpack.esql.plugin.ComputeService;
import org.elasticsearch.xpack.esql.plugin.EsqlFlags;
import org.elasticsearch.xpack.esql.plugin.EsqlPlugin;
import org.elasticsearch.xpack.esql.plugin.TransportActionServices;
import org.elasticsearch.xpack.esql.session.Configuration;
import org.elasticsearch.xpack.esql.session.EsqlSession;
import org.elasticsearch.xpack.esql.session.Result;

public class TransportEsqlQueryAction
extends HandledTransportAction<EsqlQueryRequest, EsqlQueryResponse>
implements AsyncTaskManagementService.AsyncOperation<EsqlQueryRequest, EsqlQueryResponse, EsqlQueryTask> {
    private final ThreadPool threadPool;
    private final PlanExecutor planExecutor;
    private final ComputeService computeService;
    private final ExchangeService exchangeService;
    private final ClusterService clusterService;
    private final Executor requestExecutor;
    private final EnrichPolicyResolver enrichPolicyResolver;
    private final EnrichLookupService enrichLookupService;
    private final LookupFromIndexService lookupFromIndexService;
    private final AsyncTaskManagementService<EsqlQueryRequest, EsqlQueryResponse, EsqlQueryTask> asyncTaskManagementService;
    private final RemoteClusterService remoteClusterService;
    private final UsageService usageService;
    private final TransportActionServices services;
    private volatile boolean defaultAllowPartialResults;

    @Inject
    public TransportEsqlQueryAction(TransportService transportService, ActionFilters actionFilters, PlanExecutor planExecutor, SearchService searchService, ExchangeService exchangeService, ClusterService clusterService, ThreadPool threadPool, BigArrays bigArrays, BlockFactoryProvider blockFactoryProvider, Client client, NamedWriteableRegistry registry, IndexNameExpressionResolver indexNameExpressionResolver, UsageService usageService) {
        super("indices:data/read/esql", transportService, actionFilters, EsqlQueryRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.threadPool = threadPool;
        this.planExecutor = planExecutor;
        this.clusterService = clusterService;
        this.requestExecutor = threadPool.executor("search");
        exchangeService.registerTransportHandler(transportService);
        this.exchangeService = exchangeService;
        this.enrichPolicyResolver = new EnrichPolicyResolver(clusterService, transportService, planExecutor.indexResolver());
        AbstractLookupService.LookupShardContextFactory lookupLookupShardContextFactory = AbstractLookupService.LookupShardContextFactory.fromSearchService(searchService);
        this.enrichLookupService = new EnrichLookupService(clusterService, searchService.getIndicesService(), lookupLookupShardContextFactory, transportService, indexNameExpressionResolver, bigArrays, blockFactoryProvider.blockFactory());
        this.lookupFromIndexService = new LookupFromIndexService(clusterService, searchService.getIndicesService(), lookupLookupShardContextFactory, transportService, indexNameExpressionResolver, bigArrays, blockFactoryProvider.blockFactory());
        this.asyncTaskManagementService = new AsyncTaskManagementService(".async-search", client, "async_search", registry, this.taskManager, EsqlQueryAction.INSTANCE.name(), (AsyncTaskManagementService.AsyncOperation)this, EsqlQueryTask.class, clusterService, threadPool, bigArrays);
        this.remoteClusterService = transportService.getRemoteClusterService();
        this.usageService = usageService;
        this.services = new TransportActionServices(transportService, searchService, exchangeService, clusterService, indexNameExpressionResolver, usageService, new InferenceRunner(client, threadPool));
        this.computeService = new ComputeService(this.services, this.enrichLookupService, this.lookupFromIndexService, threadPool, bigArrays, blockFactoryProvider.blockFactory());
        this.defaultAllowPartialResults = (Boolean)EsqlPlugin.QUERY_ALLOW_PARTIAL_RESULTS.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(EsqlPlugin.QUERY_ALLOW_PARTIAL_RESULTS, v -> {
            this.defaultAllowPartialResults = v;
        });
    }

    protected void doExecute(Task task, EsqlQueryRequest request, ActionListener<EsqlQueryResponse> listener) {
        this.requestExecutor.execute((Runnable)ActionRunnable.wrap((ActionListener)listener.delegateFailureAndWrap(ActionListener::respondAndRelease), l -> this.doExecuteForked(task, request, (ActionListener<EsqlQueryResponse>)l)));
    }

    private void doExecuteForked(Task task, EsqlQueryRequest request, ActionListener<EsqlQueryResponse> listener) {
        assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"search"}));
        if (TransportEsqlQueryAction.requestIsAsync(request)) {
            this.asyncTaskManagementService.asyncExecute((TaskAwareRequest)request, request.waitForCompletionTimeout(), request.keepAlive(), request.keepOnCompletion(), listener);
        } else {
            this.innerExecute(task, request, listener);
        }
    }

    public void execute(EsqlQueryRequest request, EsqlQueryTask task, ActionListener<EsqlQueryResponse> listener) {
        task.setExecutionInfo(this.createEsqlExecutionInfo(request));
        ActionListener.run(listener, l -> this.innerExecute((Task)task, request, (ActionListener<EsqlQueryResponse>)l));
    }

    private void innerExecute(Task task, EsqlQueryRequest request, ActionListener<EsqlQueryResponse> listener) {
        if (request.allowPartialResults() == null) {
            request.allowPartialResults(this.defaultAllowPartialResults);
        }
        EsqlFlags flags = this.computeService.createFlags();
        Configuration configuration = new Configuration(ZoneOffset.UTC, request.locale() != null ? request.locale() : Locale.US, null, this.clusterService.getClusterName().value(), request.pragmas(), (Integer)this.clusterService.getClusterSettings().get(EsqlPlugin.QUERY_RESULT_TRUNCATION_MAX_SIZE), (Integer)this.clusterService.getClusterSettings().get(EsqlPlugin.QUERY_RESULT_TRUNCATION_DEFAULT_SIZE), request.query(), request.profile(), request.tables(), System.nanoTime(), request.allowPartialResults());
        String sessionId = this.sessionID(task);
        EsqlExecutionInfo executionInfo = this.getOrCreateExecutionInfo(task, request);
        FoldContext foldCtx = configuration.newFoldContext();
        EsqlSession.PlanRunner planRunner = (plan, resultListener) -> this.computeService.execute(sessionId, (CancellableTask)task, flags, plan, configuration, foldCtx, executionInfo, (ActionListener<Result>)resultListener);
        this.planExecutor.esql(request, sessionId, configuration, foldCtx, this.enrichPolicyResolver, executionInfo, (IndicesExpressionGrouper)this.remoteClusterService, planRunner, this.services, (ActionListener<Result>)ActionListener.wrap(result -> {
            this.recordCCSTelemetry(task, executionInfo, request, null);
            listener.onResponse((Object)this.toResponse(task, request, configuration, (Result)result));
        }, ex -> {
            this.recordCCSTelemetry(task, executionInfo, request, (Exception)ex);
            listener.onFailure(ex);
        }));
    }

    private void recordCCSTelemetry(Task task, EsqlExecutionInfo executionInfo, EsqlQueryRequest request, @Nullable Exception exception) {
        TimeValue took;
        if (!executionInfo.isCrossClusterSearch()) {
            return;
        }
        CCSUsage.Builder usageBuilder = new CCSUsage.Builder();
        usageBuilder.setClientFromTask(task);
        if (exception != null) {
            if (exception instanceof VerificationException) {
                VerificationException ve = (VerificationException)((Object)exception);
                CCSUsageTelemetry.Result failureType = this.classifyVerificationException(ve);
                if (failureType != CCSUsageTelemetry.Result.UNKNOWN) {
                    usageBuilder.setFailure(failureType);
                } else {
                    usageBuilder.setFailure(exception);
                }
            } else {
                usageBuilder.setFailure(exception);
            }
        }
        if ((took = executionInfo.overallTook()) != null) {
            usageBuilder.took(took.getMillis());
        }
        if (request.async()) {
            usageBuilder.setFeature("async");
        }
        AtomicInteger remotesCount = new AtomicInteger();
        executionInfo.getClusters().forEach((clusterAlias, cluster) -> {
            if (cluster.getStatus() == EsqlExecutionInfo.Cluster.Status.SKIPPED) {
                usageBuilder.skippedRemote(clusterAlias);
            } else {
                usageBuilder.perClusterUsage(clusterAlias, cluster.getTook());
            }
            if (!clusterAlias.equals("")) {
                remotesCount.getAndIncrement();
            }
        });
        assert (remotesCount.get() > 0) : "Got cross-cluster search telemetry without any remote clusters";
        usageBuilder.setRemotesCount(remotesCount.get());
        this.usageService.getEsqlUsageHolder().updateUsage(usageBuilder.build());
    }

    private CCSUsageTelemetry.Result classifyVerificationException(VerificationException exception) {
        if (exception.getDetailedMessage().contains("Unknown index")) {
            return CCSUsageTelemetry.Result.NOT_FOUND;
        }
        return CCSUsageTelemetry.Result.UNKNOWN;
    }

    private EsqlExecutionInfo getOrCreateExecutionInfo(Task task, EsqlQueryRequest request) {
        EsqlQueryTask esqlQueryTask;
        if (task instanceof EsqlQueryTask && (esqlQueryTask = (EsqlQueryTask)task).executionInfo() != null) {
            return esqlQueryTask.executionInfo();
        }
        return this.createEsqlExecutionInfo(request);
    }

    private EsqlExecutionInfo createEsqlExecutionInfo(EsqlQueryRequest request) {
        return new EsqlExecutionInfo(clusterAlias -> this.remoteClusterService.isSkipUnavailable(clusterAlias), request.includeCCSMetadata());
    }

    private EsqlQueryResponse toResponse(Task task, EsqlQueryRequest request, Configuration configuration, Result result) {
        List<ColumnInfoImpl> columns = result.schema().stream().map(c -> {
            ArrayList<String> originalTypes;
            if (c.originalTypes() == null) {
                originalTypes = null;
            } else {
                originalTypes = new ArrayList<String>(c.originalTypes());
                Collections.sort(originalTypes);
            }
            return new ColumnInfoImpl(c.name(), c.dataType().outputType(), originalTypes);
        }).toList();
        EsqlQueryResponse.Profile profile = configuration.profile() ? new EsqlQueryResponse.Profile(result.completionInfo().driverProfiles(), result.completionInfo().planProfiles()) : null;
        this.threadPool.getThreadContext().addResponseHeader("X-Elasticsearch-Async-Is-Running", "?0");
        if (task instanceof EsqlQueryTask) {
            EsqlQueryTask asyncTask = (EsqlQueryTask)task;
            if (request.keepOnCompletion()) {
                String asyncExecutionId = asyncTask.getExecutionId().getEncoded();
                this.threadPool.getThreadContext().addResponseHeader("X-Elasticsearch-Async-Id", asyncExecutionId);
                return new EsqlQueryResponse(columns, result.pages(), result.completionInfo().documentsFound(), result.completionInfo().valuesLoaded(), profile, request.columnar(), asyncExecutionId, false, request.async(), result.executionInfo());
            }
        }
        return new EsqlQueryResponse(columns, result.pages(), result.completionInfo().documentsFound(), result.completionInfo().valuesLoaded(), profile, request.columnar(), request.async(), result.executionInfo());
    }

    final String sessionID(Task task) {
        return new TaskId(this.clusterService.localNode().getId(), task.getId()).toString();
    }

    public ExchangeService exchangeService() {
        return this.exchangeService;
    }

    public EnrichLookupService enrichLookupService() {
        return this.enrichLookupService;
    }

    public EsqlQueryTask createTask(EsqlQueryRequest request, long id, String type, String action, TaskId parentTaskId, Map<String, String> headers, Map<String, String> originHeaders, AsyncExecutionId asyncExecutionId) {
        return new EsqlQueryTask(id, type, action, request.getDescription(), parentTaskId, headers, originHeaders, asyncExecutionId, request.keepAlive());
    }

    public EsqlQueryResponse initialResponse(EsqlQueryTask task) {
        String asyncExecutionId = task.getExecutionId().getEncoded();
        this.threadPool.getThreadContext().addResponseHeader("X-Elasticsearch-Async-Id", asyncExecutionId);
        this.threadPool.getThreadContext().addResponseHeader("X-Elasticsearch-Async-Is-Running", "?1");
        return new EsqlQueryResponse(List.of(), List.of(), 0L, 0L, null, false, asyncExecutionId, true, true, task.executionInfo());
    }

    public EsqlQueryResponse readResponse(StreamInput inputStream) throws IOException {
        throw new AssertionError((Object)"should not reach here");
    }

    private static boolean requestIsAsync(EsqlQueryRequest request) {
        return request.async();
    }

    public LookupFromIndexService getLookupFromIndexService() {
        return this.lookupFromIndexService;
    }
}

