/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.io.stream;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamOutput;
import org.elasticsearch.xpack.esql.session.Configuration;

public class PlanStreamWrapperQueryBuilder
implements QueryBuilder {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(QueryBuilder.class, "planwrapper", PlanStreamWrapperQueryBuilder::new);
    private final Configuration configuration;
    private final QueryBuilder next;

    public PlanStreamWrapperQueryBuilder(Configuration configuration, QueryBuilder next) {
        this.configuration = configuration;
        this.next = next;
    }

    public PlanStreamWrapperQueryBuilder(StreamInput in) throws IOException {
        this.configuration = Configuration.readWithoutTables(in);
        PlanStreamInput planStreamInput = new PlanStreamInput(in, in.namedWriteableRegistry(), this.configuration);
        this.next = (QueryBuilder)planStreamInput.readNamedWriteable(QueryBuilder.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.configuration.withoutTables().writeTo(out);
        new PlanStreamOutput(out, this.configuration).writeNamedWriteable((NamedWriteable)this.next);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ESQL_FIXED_INDEX_LIKE_8_19;
    }

    public Query toQuery(SearchExecutionContext context) throws IOException {
        return this.next.toQuery(context);
    }

    public QueryBuilder queryName(String queryName) {
        this.next.queryName(queryName);
        return this;
    }

    public String queryName() {
        return this.next.queryName();
    }

    public float boost() {
        return this.next.boost();
    }

    public QueryBuilder boost(float boost) {
        this.next.boost(boost);
        return this;
    }

    public String getName() {
        return this.getWriteableName();
    }

    public String getWriteableName() {
        return PlanStreamWrapperQueryBuilder.ENTRY.name;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.next.toXContent(builder, params);
    }

    public QueryBuilder next() {
        return this.next;
    }
}

