/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.inference.completion;

import java.util.List;
import java.util.NoSuchElementException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.core.inference.action.InferenceAction;
import org.elasticsearch.xpack.esql.inference.bulk.BulkInferenceRequestIterator;

public class CompletionOperatorRequestIterator
implements BulkInferenceRequestIterator {
    private final PromptReader promptReader;
    private final String inferenceId;
    private final int size;
    private int currentPos = 0;

    public CompletionOperatorRequestIterator(BytesRefBlock promptBlock, String inferenceId) {
        this.promptReader = new PromptReader(promptBlock);
        this.size = promptBlock.getPositionCount();
        this.inferenceId = inferenceId;
    }

    @Override
    public boolean hasNext() {
        return this.currentPos < this.size;
    }

    @Override
    public InferenceAction.Request next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.inferenceRequest(this.promptReader.readPrompt(this.currentPos++));
    }

    private InferenceAction.Request inferenceRequest(String prompt) {
        if (prompt == null) {
            return null;
        }
        return InferenceAction.Request.builder((String)this.inferenceId, (TaskType)TaskType.COMPLETION).setInput(List.of(prompt)).build();
    }

    @Override
    public int estimatedSize() {
        return this.promptReader.estimatedSize();
    }

    public void close() {
        Releasables.close((Releasable)this.promptReader);
    }

    private static class PromptReader
    implements Releasable {
        private final BytesRefBlock promptBlock;
        private final StringBuilder strBuilder = new StringBuilder();
        private BytesRef readBuffer = new BytesRef();

        private PromptReader(BytesRefBlock promptBlock) {
            this.promptBlock = promptBlock;
        }

        public String readPrompt(int pos) {
            if (this.promptBlock.isNull(pos)) {
                return null;
            }
            this.strBuilder.setLength(0);
            for (int valueIndex = 0; valueIndex < this.promptBlock.getValueCount(pos); ++valueIndex) {
                this.readBuffer = this.promptBlock.getBytesRef(this.promptBlock.getFirstValueIndex(pos) + valueIndex, this.readBuffer);
                this.strBuilder.append(this.readBuffer.utf8ToString());
                if (valueIndex == this.promptBlock.getValueCount(pos) - 1) continue;
                this.strBuilder.append("\n");
            }
            return this.strBuilder.toString();
        }

        public int estimatedSize() {
            return this.promptBlock.getPositionCount();
        }

        public void close() {
        }
    }
}

