/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.nulls;

import java.io.IOException;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.core.expression.predicate.Negatable;
import org.elasticsearch.xpack.esql.core.querydsl.query.ExistsQuery;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;

public class IsNotNull
extends UnaryScalarFunction
implements EvaluatorMapper,
Negatable<UnaryScalarFunction>,
TranslationAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "IsNotNull", IsNotNull::new);

    public IsNotNull(Source source, Expression field) {
        super(source, field);
    }

    private IsNotNull(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return IsNotNull.ENTRY.name;
    }

    protected NodeInfo<IsNotNull> info() {
        return NodeInfo.create((Node)this, IsNotNull::new, (Object)this.field());
    }

    protected IsNotNull replaceChild(Expression newChild) {
        return new IsNotNull(this.source(), newChild);
    }

    public Object fold(FoldContext ctx) {
        return !DataType.isNull((DataType)this.field().dataType()) && this.field().fold(ctx) != null;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        return new IsNotNullEvaluatorFactory(toEvaluator.apply(this.field()));
    }

    public Nullability nullable() {
        return Nullability.FALSE;
    }

    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    public UnaryScalarFunction negate() {
        return new IsNull(this.source(), this.field());
    }

    @Override
    public TranslationAware.Translatable translatable(LucenePushdownPredicates pushdownPredicates) {
        return IsNull.isTranslatable(this.field(), pushdownPredicates);
    }

    @Override
    public Query asQuery(LucenePushdownPredicates pushdownPredicates, TranslatorHandler handler) {
        return new ExistsQuery(this.source(), handler.nameOf(this.field()));
    }

    record IsNotNullEvaluatorFactory(EvalOperator.ExpressionEvaluator.Factory field) implements EvalOperator.ExpressionEvaluator.Factory
    {
        public EvalOperator.ExpressionEvaluator get(DriverContext context) {
            return new IsNotNullEvaluator(context, this.field.get(context));
        }

        @Override
        public String toString() {
            return "IsNotNullEvaluator[field=" + String.valueOf(this.field) + "]";
        }
    }

    record IsNotNullEvaluator(DriverContext driverContext, EvalOperator.ExpressionEvaluator field) implements EvalOperator.ExpressionEvaluator
    {
        public Block eval(Page page) {
            try (Block fieldBlock = this.field.eval(page);){
                BooleanBlock booleanBlock;
                block15: {
                    if (fieldBlock.asVector() != null) {
                        BooleanBlock booleanBlock2 = this.driverContext.blockFactory().newConstantBooleanBlockWith(true, page.getPositionCount());
                        return booleanBlock2;
                    }
                    BooleanVector.FixedBuilder builder = this.driverContext.blockFactory().newBooleanVectorFixedBuilder(page.getPositionCount());
                    try {
                        for (int p = 0; p < page.getPositionCount(); ++p) {
                            builder.appendBoolean(p, !fieldBlock.isNull(p));
                        }
                        booleanBlock = builder.build().asBlock();
                        if (builder == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (builder != null) {
                            try {
                                builder.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    builder.close();
                }
                return booleanBlock;
            }
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable)this.field);
        }

        @Override
        public String toString() {
            return "IsNotNullEvaluator[field=" + String.valueOf(this.field) + "]";
        }
    }
}

